package it.eng.eremita.jpa.manager;

import java.io.FileReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import com.opencsv.CSVReader;
import com.opencsv.bean.OpencsvUtils;

import it.eng.eremita.jpa.entity.CondizioniMeteo;
import it.eng.eremita.jpa.entity.Limpidezza;
import it.eng.eremita.jpa.entity.Metadato;
import it.eng.eremita.jpa.entity.MetadatoHabitat;
import it.eng.eremita.jpa.entity.MonitoraggioHabitat;
import it.eng.eremita.jpa.entity.MonitoraggioSpecie;
import it.eng.eremita.jpa.entity.Segnalazione;
import it.eng.eremita.jpa.entity.SegnalazioneAltreSpecie;
import it.eng.eremita.jpa.entity.SitoNatura2000;
import it.eng.eremita.jpa.entity.Specie;
import it.eng.eremita.jpa.entity.StadioSviluppo;
import it.eng.eremita.jpa.entity.TipologiaMonitoraggio;

public class DBImporter {
	
	public static SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
	public static SimpleDateFormat sdf2 = new SimpleDateFormat("dd/MM/yyyy HH:mm");
	public static EremitaManager em;
	
	public static String COENAGRION[][] = {
			
			{"012EC16-CoeS","Coenagrion mercuriale castellanii","MAR","Fuori SIC","08/08/2016","Ecosistema","FuoriSIC_MAR_Coe_L001","","Rio 1","16.00","17.20","sole","","25","","brezza molto leggera","","","14","20 (rigagnolo 24)","","","","0","0","VES","0","0","0","0","","","","","tutti AM: Ceriagrion tenellum >100 anche copule, Orthetrum brunneum >30 anche copule, Orthetrum coerulescens >30 anche copule, Calopteryx haemorrhoidalis >30 anche copule, Platycnemis pennipes 1m-1f, Ischnura pumilio 30es. anche copule, Ischnura elegans 20 es. anche copule","","0","0","0","0","0","0","","","",""},
			{"013EC16-CoeS","Coenagrion mercuriale castellanii","MAR","Fuori SIC","23/08/2016","R. Fabbri & L. Casini","FuoriSIC_MAR_Coe_L001","","Rio 1","11.00","12.30","sole","","26","","brezza molto leggera","","","14","rio 1: 17","","","","0","0","VES","0","0","0","0","","","","","tutti AM: Ceriagrion tenellum >50, Orthetrum brunneum 5, Calopteryx haemorrhoidalis >20, Sympetrum striolatum 3 es., Ischnura pumilio 20 es., Ischnura elegans 2 es.","","0","0","0","0","0","0","","","",""},
			{"0023EC16-CoeS","Coenagrion mercuriale castellanii","MAR","Fuori SIC","24/06/2016","Ecosistema","FuoriSIC_MAR_Coe_L005-1","842","Rio Gambellaro","11.10","12.10","sole","sole 20%","30","","assente","10, max 20","elevata","23","23","","","ombreggiamento su alveo","0","0","VES","1","0","0","1","","","","varie","Rane verdi 20 es., Calopteryx splendens 15 es., Calopteryx haemorrhoidalis 30 es., Platycnemis pennipes 50 es., Orthetrum brunneum 5 es., Libellula depressa 1 es. m, Onychogomphus forcipatus unguiculatus 3 es. m, Ischnura elegans 15 es., Crocothemis erythraea 5 es. m, Coenagrion puella 1 es. m piccolo (foto), Anax imperator 1 es. m                           Lepidotteri: Iphiclides podalirius 1 es., Vanessa atalanta 1 es., Maniola jurtina 2 es., Lasiommata megera 3 es., Pararge aegeria 6 es., Pieris rapae 2 es., Pieris napi 1 es., Melanargia galathea 1 es.","","0","0","0","0","0","0","1AMm","","",""},
			{"0016EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","05/06/2017","Ecosistema & Poloni R.","IT4070011_MAR_Coe_L004","","Rio delle Zolfatare","12:00","","sole","parz.nuvoloso 20%","26,7","40,1","assente","10","elevata","17,8","19","8,34-8,55","2102-2162","Forti percolazioni di liquami da allevamenti di animali domestici","0","0","VES","0","0","0","0","","","","varie","Orthetrum coerulescens 2AMm, Calopteryx haemorrhoidalis 2AMm, Platycnemis pennipes 5 es., Vanessa atalanta 1, Gonepteryx rhamni 1m","","0","0","0","0","0","0","","","",""},
			{"016EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","30/06/2016","R. Fabbri & M. Costa","IT4070011_MAR_Coe_L004","206","Rio delle Zolfatare","","","sole","sole","","","assente","","","13","16","","","","0","0","VES","0","0","0","0","","","","varie","","","0","0","0","0","0","0","","","",""},
			{"018EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","25/05/2016","R. Fabbri","IT4070011_MAR_Coe_L004","206","Rio delle Zolfatare","15.10","15.50","sole","sole 0%","26","","assente","5-10","elevata","","14,5","","","allevamento animali domestici, chiusura della vegetazione arbustiva-arborea, captazione idrica","0","0","VES","0","1","0","1","","","","varie","Calopteryx splendens 2es.","","0","0","0","0","0","0","1AIf","","",""},
			{"019EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","09/09/2016","Ecosistema","IT4070011_MAR_Coe_L004","206","Rio delle Zolfatare","16.00","16.30","sole","sole 0%","27,5","","assente","5","","","18,5","","","polli in alveo, molti rifiuti (plastica, escrementi animali di allevamento) in alveo corso in parte deviato verso allevamento","0","0","VES","0","0","0","0","","","","varie","Chalcolestes viridis 3m, Calopteryx haemorrhoidalis 3m e 2f, Sympetrum striolatum 1m","erba e canna sfalciata e due salici tagliati (bene)","0","0","0","0","0","0","","","",""},
			{"021EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","24/06/2016","Ecosistema","IT4070011_MAR_Coe_L004","","Rio delle Zolfatare","19.00","19.20","sole","sole 30%","","","","","","","","","","rio in parte deviato verso allevamento, troppa ombra per alberi, rovi e anche salici capitozzati ","0","0","VES","0","0","0","0","","","","varie","Calopteryx splendens 3m e 1f, Platycnemis pennipes 10 es.","","0","0","0","0","0","0","","","",""},
			{"023EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","24/06/2016","Ecosistema","IT4070011_MAR_Coe_L005-2","330","Rio Gambellaro","13.00","13.25","sole","sole 0%","29","","assente","10, max 20","elevata","21","21","","","ombreggiamento su alveo, animali domestici in alveo (oche, anatre)","0","0","VES","0","0","0","0","","","","varie","cavedani e alborelle, rane verdi; Calopteryx haemorrhoidalis 30 es., Platycnemis pennipes 50 es., Orthetrum brunneum 5 es., Orthetrum coerulescens 3 es., Cordulegaster boltoni 1 es. m.                                                            Lepidotteri: Pieris brassicae 1 es., Leptidea sinapis 7 es., Ochlodes venatus 1 es.","","0","0","0","0","0","0","","","",""},
			{"0003EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","13/04/2017","Fabbri R. & Poloni R.","IT4070011_MAR_Coe_L005-3","","Rio Gambellaro","16:00","17:10","sole","sole 10%","21-26","35,0","quasi assente 2m/s zona esposta","30 max","elevata","","16","7,64","2500","","0","0","VES","0","0","0","0","","","","varie","Deronectes sp., Drypta dentata 2, Anthocaris cardamines 10, Polygonia c-album 1, Leptidea sinapis 7, Iphiclides podalirius 5, Pieris brassicae 1, Pararge aegeria 2, Pieris brassicae 1, Pieris napi 2, Pieris rapae 3, Lasiommata megera >10 es., Licenidi vari 30 es.","","0","0","0","0","0","0","","","",""},
			{"0007EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","07/05/2017","Fabbri R., Poloni R., Giangregorio P.","IT4070011_MAR_Coe_L005-3","","Rio Gambellaro","15:30","16:30","pioggia, 100%","sole 0%","16","75","1,9 m/s SO","20 max","elevata","14","14","","","","0","0","VES","0","1","0","1","","","","varie","Nepa in acqua","","0","0","0","0","0","0","1AMf","","",""},
			{"0009EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","11/05/2017","Serra A., Fabbri R. & Poloni R.","IT4070011_MAR_Coe_L005-3","","Rio Gambellaro","10:00","11:00","nuvoloso 100%","sole 0%","19","63","0,0-1,0 m/s","","","13","","7,98","2200","","0","0","VES","5","2","0","7","","","","varie","","","0","0","0","0","0","0","3AMm, 1AIm, 2AMf","1AIm","",""},
			{"0010EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","17/05/2017","Poloni R.","IT4070011_MAR_Coe_L005-3","","Rio Gambellaro","09:30","11:15","sole 0%","sole","24,5","","0,0 m/s","25","","","","","","","0","0","VES","7","7","0","14","","","","varie","Calopteryx splendens 4 es. Altro: Cicindela campestris, Oxythyrea funesta, Cetonia aurata, Luciola italica, Pararge aegeria, Papilio machaon,","","0","0","0","0","0","0","3AMm, 2AIm, 5AMf","2AMm, 1AIm, 2AMf","",""},
			{"0013EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","31/05/2017","Poloni R.","IT4070011_MAR_Coe_L005-3","","Rio Gambellaro","10:30","12:30","sole 10%","sole","29,1","44,5","0,0m/s","20","elevata","","","","","","0","0","VES","18","5","0","23","","","","varie","Calopteryx splendens 13, Platycnemis pennipes >50","","0","0","0","0","0","4","8AMm, 3AMf","5AMm, 1AIm, 2AMf","4AMm",""},
			{"0021EC-EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","19/06/2017","Ecosistema","IT4070011_MAR_Coe_L005-3","","Rio Gambellaro","12:20","14:00","sole 0%","sole","28","36","0,0-2,2 m/sec - Est","10","elevata","19,5","19,5","7,72","2500","","0","0","VES","6","1","0","7","","","","varie","Platycnemis pennipes >100, Calopteryx haemorrhoidalis >100, Orthethrum coerulescens >10, Cordulegaster boltoni 3AMm, Calopteryx splendens >10, Somatochlora meridionalis 4AMm; Lepidotteri: Maniola jurtina >30, Iphiclides podalirius 1, Gonepteryx rhamni 1m, Melanargia galathea 5, Lasiommata megera 10, Polyommatus icarus >20, Melitaea phoebe 2, Gegenes nostrodamus 1, Melitaea didyma 3, Pieris rapae 3","","0","0","0","0","0","0","6AMm, 1AMf","0","0",""},
			{"014EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","30/06/2016","R. Fabbri & M. Costa","IT4070011_MAR_Coe_L005-3","","Rio Gambellaro","11.00","12.00","sole","sole","26","","assente","","","","","","","","0","0","VES","12","2","0","14","","","","varie","Cordulegaster boltoni 2 es.","","0","0","0","0","0","1","","","",""},
			{"023EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","24/06/2016","Ecosistema","IT4070011_MAR_Coe_L005-3","772","Rio Gambellaro","13.27","14.55","sole","sole","29","","assente","10, max 20","elevata","21","21","","","ombreggiamento su alveo","0","0","VES","8","0","0","8","","","","varie","Calopteryx splendens 30 es., Calopteryx haemorrhoidalis 30 es., Platycnemis pennipes 50 es., Orthetrum coerulescens 1 es., Orthetrum cancellatum 1 es. f, Libellula depressa 1 es. f, Cordulegaster boltoni 1 es. m                           Lepidotteri: Maniola jurtina 20 es., Lasiommata megera 3 es., Pararge aegeria 1 es., Leptidea sinapis 15 es., Melanargia galathea 1 es., Polyommatus sp. 8 es., Polyommatus dolus? 1 es. m, Coenonympha pamphilus 10 es., Melitaea didyma 2 es., Melitaea phoebe 2 es., Maculinea arion 1 es. m (foto) ","","0","0","0","0","0","0","1AMm","6AMm, 1AIm","",""},
			{"0019EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","05/06/2017","Ecosistema & Poloni R.","IT4070011_MAR_Coe_L006-1","260","Rio Cavinale","18:20","18:56","sole 50%","sole","23","60,3","0,0 m/s","10-15","elevata","15","15","8,03","2100","","0","0","VES","0","0","0","0","","","","varie","","","0","0","0","0","0","0","","","",""},
			{"0019EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","05/06/2017","Ecosistema & Poloni R.","IT4070011_MAR_Coe_L006-2","255","Rio Cavinale","18:20","18:56","sole 50%","sole","23","55,2","0,0 m/s","10-15","elevata","12,5","15","8,02","2200","","0","0","VES","0","0","0","0","","","","varie","Platycnemis pennipes 1 es.","","0","0","0","0","0","0","","","",""},
			{"015EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","30/06/2016","R. Fabbri & M. Costa","IT4070011_MAR_Coe_L006-2","255","Rio Cavinale","","","sole","sole","","","assente","","","","16","","","","0","0","VES","0","0","0","0","","","","varie","","","0","0","0","0","0","0","","","",""},
			{"020EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","24/06/2016","Ecosistema","IT4070011_MAR_Coe_L006-2","255","Rio Cavinale","17.47","18.26","sole","sole","26,5","","assente","5-30","elevata","13","13","","","diserbo su sponda sx, grano fino al margine su sponda dx, pulizia corso","0","0","VES","0","0","0","0","","","","varie","Aeshna affinis 1m, Calopteryx splendens 1m, Platycnemis pennipes 10 es., Calopteryx haemorrhoidalis 1m","","0","0","0","0","0","0","","","",""},
			{"0017EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","30/06/2016","R. Fabbri & M. Costa","IT4070011_MAR_Coe_L007","199","Rio Basino","","","sole","sole","25","","assente","","","","","","","","0","0","VES","0","0","0","0","","","","varie","","","0","0","0","0","0","0","","","",""},
			{"022EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","24/06/2016","Ecosistema","IT4070011_MAR_Coe_L007","199","Rio Basino","16.40","17.00","sole","sole","","","","","","","","","","ombreggiamento e chiusura alveo per salici, olmi, acero campestre, acero negundo, robinia, Phragmites","0","0","VES","0","0","0","0","","","","varie","Calopteryx splendens 10 es., Calopteryx haemorrhoidalis 5 es., Platycnemis pennipes oltre 40 es.                                              Lepidotteri: Gonopteryx rhamni 1m, Pieris brassicae 3 es., Leptidea sinapis 1 es., Melanargia galathea 8 es., Colias croceus 1 es., Thymelicus lineola 1 es., Coenonympha pamphilus 5 es., Pieris napi 3 es., Pararge aegeria 8 es., Lasiommata megera 3 es., Thymelicus sylvestris 1 es., Melitaea phoebe 2 es., Gegenes nostrodamus 1 es.","","0","0","0","0","0","0","","","",""},
			{"0014EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","31/05/2017","Ecosistema & Poloni R.","IT4070011_MAR_Coe_L008","348","Rio Stella","19:00","20:00","sole 10%","sole","24","38,6","0,2-1,7 m/s","3-10","media","18","18","7,93","1080","","0","0","VES","1","0","0","1","","","","varie","Coenagrion puella 2, Platycnemis pennipes 15, Coenagrion scitulum 2","","0","0","0","0","0","0","1AMm","","",""},
			{"0017EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","05/06/2017","Ecosistema & Poloni R.","IT4070011_MAR_Coe_L008","348","Rio Stella","15:00","16:45","sole 60%","sole","23,0-26,0","48","0,6m/s est","5","elevata","","19","7,47","1050","","0","0","VES","1","2","0","3","","","","varie","Coenagrion puella 30, Ischnura elegans 10, Anax imperator 1AMm, Pyrrhosoma nimphula 1AMm 1AMf, Orthetrum brunneum 10, Sympetrum sanguineum 2m, Platycnemis pennipes 50","","0","0","0","0","0","0","1AMm, 2AMf","","",""},
			{"0023EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","26/06/2017","Ecosistema & Poloni R.","IT4070011_MAR_Coe_L008","348","Rio Stella","16:40","17:20","sole/nuvoloso 60%","sole","26","59","0,0-3,2 m/sec - Est","5","elevata","16","22","8,04-7,94","1340-940","","0","0","VES","0","0","0","0","","","","varie","Platycnemis pennipes >10, Aeshna affinis 1AMm, Calopteryx haemorrhoidalis >5, Orthetrum coerulescens 1AMm","","0","0","0","0","0","0","0","","",""},
			{"0014EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","31/05/2017","Ecosistema & Poloni R.","IT4070011_MAR_Coe_L009","197","Rio del Diavolo","19:00","20:00","sole 10%","sole","24","38,6","0,2-1,7 m/s","3-10","elevata","18","18","7,93","1080","","0","0","VES","0","0","0","0","","","","varie","","","0","0","0","0","0","0","0","","",""},
			{"0017EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","05/06/2017","Ecosistema & Poloni R.","IT4070011_MAR_Coe_L009","197","Rio del Diavolo","15:00","16:45","sole 60%","sole","23,0-26,0","45,5","0,6 m/s est","5","elevata","","19","8,00","1020","","0","0","VES","0","0","0","0","","","","varie","Platycnemis pennipes 50, Coenagrion puella 30, Pyrrhosoma nymphula 1m 1f; nel lago alto: Anax parthenope 1m, Orthetrum coerulescens 5, Platycnemis pennipes 20","","0","0","0","0","0","0","","","",""},
			{"0023EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4070011","26/06/2017","Ecosistema & Poloni R.","IT4070011_MAR_Coe_L009","197","Rio del Diavolo","16:40","17:20","sole/nuvoloso 60%","sole","26","59","0,0-1,0 m/sec - Est","5","elevata","19","19","7,67","870","","0","0","VES","0","0","0","0","","","","varie","Platycnemis pennipes >15, Calopteryx haemorrhoidalis 2","","0","0","0","0","0","0","0","","",""},
			{"0001EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","06/04/2017","Fabbri R.","IT4090002_MAR_Coe_L001","578","Rio 1","15:00","17:20","sole","sole","20","","","","elevata","14","15","7,71","680","Nutrie, vegetazione arborea e arbustiva in esubero","0","0","VES","1","0","0","1","","","","varie","Brachytron pratense 1 es. m","","0","0","0","0","0","0","1AIm","","",""},
			{"0002EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","13/04/2017","Fabbri R. & Poloni R.","IT4090002_MAR_Coe_L001","","Rio 1","10.30","13:30","sole","","23,5","41,0","medio, NO 3,4 m/s","25 max","elevata","14","17","7,85","730","","0","0","VES","75","9","0","90","","","","varie","Sympecma fusca 5AMm, 2AMf, Ceriagrion tenellum 1AIm, Ischura elegans 1AMm, Libellula depressa 2AMm, Ischnura pumilio 1AMm ALTRO: Lamia textor 1 es., Gonepteryx rhamni 1, Papilio machaon 3, Iphiclides podalirius 2, Carcharodes sp. 1, Pyrgus sp. 1, Colias croceus 1, Leptidea sinapis 3, Pararge aegeria 3, Lasiommata megera 7, Bufo bufo 1m in canto, Pelophylax sp. in canto >30 es.","","0","0","0","0","0","4","34AMm, 13AIm, 3AMf, 2AIf","1AMm, 2AIm","","25AMm, 4AMf"},
			{"0004EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","19/04/2017","Fabbri R. & Poloni R. & De Curtis O.","IT4090002_MAR_Coe_L001","","Rio 1","11:15","12:45","sole","","14","29,0","2,9m/s","25 max","elevata","14","14,5","7,85","790","","0","0","VES","41","2","0","43","","","","varie","Ischnura pumilio 4AMm 1AMf, Ischnura elegans 2, Sympecma fusca 5","","0","0","0","0","0","1","26AMm, 14AIm, 1AMf","","","1AMm, 1AMf"},
			{"0005EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","30/04/2017","Fabbri R. & Poloni R.","IT4090002_MAR_Coe_L001","","Rio 1","10:45","11:45","sole","sole 20%","17,5-18,5","43","inizio 0-3,0m/s fine 1,8-4,5m/s","20 max","elevata","14","14","","","","0","0","VES","50","3","0","53","","","","varie","Ischnura pumilio >10, Libellula depressa 1m, Sympecma fusca 1m, Ischnura elegans 1m, Coenagrion puella 1m, Sympetrum sp. 1AIm, Lestes virens 1, Ceriagrion tenellum >10; altro: Melitaea didyma 1, Vanessa cardui 1, Lasiommata megera 3","","0","0","0","0","0","0","36AMm, 13AIm, 1AMf, 4AIf","","","1AMm"},
			{"0006EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","05/05/2017","Fabbri R. & Poloni R.","IT4090002_MAR_Coe_L001","","Rio 1","11:15","15:15","parzialmente nuvoloso 40%","parz.nuvoloso 20%","22","33,0-36,5","0,3-2,7 m/s","20 max","elevata","14","17,5","8,03","760","","0","0","VES","170","46","0","216","","","","varie","Ischnura pumilio 11, Libellula depressa 1, Sympecma fusca 17, Orthethrum brunneum 3, Coenagrion puella 1AMm, Pyrrhosoma nymphula 1AIm; altro: Iphiclides podalirius 1, Leptidea sinapis 4, Carcharodes sp. 3, Gonepteryx rhamni 1","","0","0","0","0","0","36","108AMm, 13AIm, 33AMf, 3AIf","17AMm, 4AIm, 2AMf","2AMm","24AMm, 2AIm, 8AMf"},
			{"0008EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","11/05/2017","Fabbri R., Poloni R. & Ruocco M.","IT4090002_MAR_Coe_L001","","Rio 1","16:30","18:30","","sole","21,0-22,0","45,0-54,0","0,0-3,0m/s","20-30","","14","16","7,83","750","","0","0","VES","164","22","0","186","","","","varie","Calopteryx haemorrhoidalis 1AMm, Platycnemis pennipes 3, Pyrrhosoma nymphula 2, Sympecma fusca >5, Coenagrion puella >5, Calopteryx splendens 1AIm, Sympetrum sp. 1, Ischnura pumilio 1, Ischnura elegans >5","","0","0","0","0","0","0","109AMm, 12AIm, 4AMf, 7AIf","16AMm, 7AIm, 4AMf","4AMm","10AMm, 6AIm, 6AMf, 1AIf"},
			{"0011EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","18/05/2017","Poloni R.","IT4090002_MAR_Coe_L001","","Rio 1","10:30","15:30","sole 0%","sole 0%","25,5","50,4","0,0-4,3 m/s NE-SO","30 max","elevata","","","","","","0","0","VES","84","44","0","128","","","","varie","Ischnura elegans >20, Ceriagrion tenellum >200, Calopteryx splendens 3, Libellula depressa 1, Orthetrum brunneum >50, Orthethrum sp., Sympecma fusca 10, Rana verde >50es.","","0","0","0","0","0","38","37AMm, 7AIm, 10AMf, 4AIf","9AMm, 1AMf","2AMm, 1AIm, 1AMf","27AMm, 1AIm, 18AMf"},
			{"0012EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","25/05/2017","Poloni R.","IT4090002_MAR_Coe_L001","","Rio 1","11:00","16:00","parz. nuvoloso 70%","sole 0%","24,7","48,8","0,0-3,8 m/s NE-SO","15 max","elevata","","","","","","0","0","VES","58","13","0","71","","","","varie","Calopteryx splendens >30, Ceriagrion tenellum >200, Orthetrum sp., Orthetrum brunneum >30, Ischnura elegans >15, Iscnura pumilio >15, Vanessa atalanta 1, Colias croceus 10, Rana verde 10","vento forte","0","0","0","0","0","9","27AMm, 7AIm, 4AMf, 3AIf","8AMm, 2AMf","0","16 AMm, 4AMf"},
			{"0015EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","01/06/2017","Ecosistema & Poloni R.","IT4090002_MAR_Coe_L001","","Rio 1","16:30","18:00","sole ","sole 30%","26,5-28,0","32","0,5-3,8 m/s","10","elevata","14","19,5","7,88","760","","0","0","VES","89","15","0","104","","","","varie","Platycnemis pennipes >100, Orthetrum brunneum >5, Orthetrum coerulescens >10, Lestes virens 1, Libellula depressa 1, Calopteryx haemorrhoidalis >10, Coenagrion puella 10, Ceriagrion tenellum >200, Sympetrum sanguineum 4","","0","0","0","0","0","1","43AMm, 1AIm, 3AMf, 2AIf","8AMm, 2AIm, 1AMf, 1AIf","6AMm, 1AMf","27AMm, 2AIm, 7AMf"},
			{"001EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","12/04/2016","Fabbri R.","IT4090002_MAR_Coe_L001","","Rio 1","17:00","19:15","sole 0%","sole 0%","27,0-31,0","33,0","0,3-3,7 m/s","10","elevata","14,5","21,5","7,88","740","","0","0","VES","25","3","0","28","","","","varie","Platycnemis pennipes 10, Coenagrion puella 3AMm 1AMf, Calopteryx haemorrhoidalis 10, Orthethrum coerulescens 15, Ceriagrion tenellum >30, Ischnura elegans 5, Ischnura pumilio 2, Sympetrum sp. 2, Orthethrum brunneum 6, Calopteryx splendens 5; Lepidotteri: Melanargia galathea 4, Colias croceus 3, Leptidea sinapis 2, Melitaea sp. 1f (foto)","","0","0","0","0","0","0","33AMm, 3AIm, 12AMf","2AMm, 2AIm, 2AMf, ","0","14AMm, 1AIm, 2AMf"},
			{"0020EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","12/06/2017","Ecosistema & Poloni R.","IT4090002_MAR_Coe_L001","","Rio 1","15:30","18:00","sole 0%","sole 20%","29,5","25,8","0,0-2,6 m/sec","10","elevata","14,5","22","7,79","700","","0","0","VES","55","16","0","71","","","","varie","","","0","0","0","0","0","0","35AMm, 4AIm, 2AMf, 1AIf","2AMm","1AMm","11AMm, 1AIm, 8AMf"},
			{"0022EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","20/06/2017","Ecosistema & Poloni R.","IT4090002_MAR_Coe_L001","","Rio 1","14:30","17:30","sole 30%","sole 0%","27,5","38,0-43,0","0,0-3,2 m/sec - NE","10","elevata","14,5","24","7,92-8,05","650-800","","0","0","VES","54","11","0","65","","","","varie","Platycnemis pennipes >200, Calopteryx haemorrhoidalis >50, Orthethrum coerulescens >20, Ceriagrion tenellum >100, Ischnura pumilio 3AI, Orthethrum brunneum >30, Calopteryx splendens 2AMm 1AMf; Altro: Biacco 1, Nutrie 3, Pyronia tithynus 1 foto, Iphiclides podalirius 3","","0","0","0","0","0","0","9AMm, 1AIm","1AMm","0","1AMm, 1AMf"},
			{"0024EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","01/07/2017","Ecosistema & Poloni R.","IT4090002_MAR_Coe_L001","","Rio 1","17:00","18:15","sole 0%","sole 0%","31,5","36,0-39,0","0,0-0,9 m/sec - NE","10","elevata","14","24,5","7.40-7,89","700-740","","0","0","VES","12","1","0","13","","","","varie","Platycnemis pennipes >100, Calopteryx haemorrhoidalis >20, Orthethrum coerulescens 5, Ceriagrion tenellum >100, Ischnura pumilio >10, Sympecma fusca 2 juv, Calopteryx splendens 2AMm","","0","0","0","0","0","0","3AMm, 1AMf","2AMm","0","2AMm"},
			{"0025EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","06/07/2017","Ecosistema & Poloni R.","IT4090002_MAR_Coe_L001","","Rio 1","08:45","11:07","sole 10%","sole","26,5","46,5","0,0-2,7 m/sec - NE","10","elevata","14","20,5","7,40-7,90","700-770","","0","0","VES","7","1","0","8","","","","varie","Platycnemis pennipes >100, Calopteryx haemorrhoidalis >100, Orthethrum coerulescens >30, Orthetrum brunneum >30, Ceriagrion tenellum >100, Ischnura pumilio 2AMm, Ischnura elegans 3AMm, Coenagrion puella 1AMf, Calopteryx splendens 3AMm, Onychogomphus forcipatus unguiculatus 1AMm; Altro: cocomero asinino inizio transetto 3-2","","0","0","0","0","0","0","7AMm, 1AIf","0","0","3AMm"},
			{"0026EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","15/07/2017","Ecosistema","IT4090002_MAR_Coe_L001","","Rio 1","09:15","11:00","sole 0%","sole","27","47,1","0,0-1,8 m/sec - NE","10","elevata","14","21","7,95","760","","0","0","VES","10","1","0","11","","","","varie","Platycnemis pennipes, Calopteryx haemorrhoidalis, Orthethrum coerulescens, Orthetrum brunneum, Ceriagrion tenellum, Ischnura pumilio, Ischnura elegans, Coenagrion puella, Calopteryx splendens, Sympetrum striolatum 2AMm, Sympetrum fonscolombi 1AMm","","0","0","0","0","0","0","3AMm","1AMm","0","1AIm"},
			{"0027EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","21/07/2017","Ecosistema & Aguzzi S.","IT4090002_MAR_Coe_L001","","Rio 1","08:30","10:15","sole 0%","sole","26","","","10","elevata","14","22","","","","0","0","VES","5","0","0","5","","","","varie","","","0","0","0","0","0","0","2AMm","0","0","1AMf"},
			{"0028EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","26/07/2017","Ecosistema","IT4090002_MAR_Coe_L001","","Rio 1","","","sole","sole","","","","","","","","","","","0","0","VES","2","1","0","3","","","","","","","0","0","0","0","0","0","9AMm, 16Ajm, 3Ajf","","",""},
			{"002EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","19/04/2016","Fabbri R.","IT4090002_MAR_Coe_L001","","Rio 1","","","sole","sole","","","","","","","","","","","0","0","CMR","65","2","0","67","","","","varie","","","0","0","0","0","0","0","32AMm, 33Ajm, 2AMf","","",""},
			{"003EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","28/04/2016","Fabbri R.","IT4090002_MAR_Coe_L001","","Rio 1","","","sole","sole","","","","","","","","","","","0","0","CMR","72","4","0","76","","","","varie","","","0","0","0","0","0","0","51AMm, 21Ajm, 4AMf","","",""},
			{"004EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","06/05/2016","Fabbri R.","IT4090002_MAR_Coe_L001","","Rio 1","","","sole","sole","","","","","","","","","","","0","0","CMR","149","5","0","154","","","ricattura di 1 maschio marcato nel Rio1 il 28apr16","varie","","","0","0","0","0","0","0","139AMm, 10Ajm, 5AMf","","",""},
			{"005EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","12/05/2016","Fabbri R.","IT4090002_MAR_Coe_L001","","Rio 1","","","sole","sole","","","","","","","","","","","0","0","CMR","251","7","0","258","","","ricattura di 2 maschi marcati nel Rio1 il 6mag16","varie","","","0","0","0","0","0","0","245AMm, 6Ajm, 7AMf","","",""},
			{"006EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","27/05/2016","Fabbri R.","IT4090002_MAR_Coe_L001","","Rio 1","14.00","15.00","sole","sole","28","","brezza, forza 3/4","20-30","elevata, fino al fondo","14 a monte","18 a valle","","","seminativo a grano attorno, ombreggiamento alberi e arbusti e Arundo donax","0","0","VES","41","0","0","41","","","","varie","tutti AM: Ceriagrion tenellum >300 anche juv., Libellula depressa 2m, Orthetrum brunneum 4m e 2f, Orthetrum coerulescens 4m e 1f, Aeshna affinis 1m, Calopteryx haemorrhoidalis 8m e 4f, Platycnemis pennipes 6m, Coenagrion puella 7m e 3f, Ischnura elegans 3m e 2m juv., Ischnura pumilio 10m e 2f, Crocothemis erythraea 1m","","0","0","0","0","0","0","56AMm, 2Ajm, 6AMf","","",""},
			{"006EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","27/05/2016","Fabbri R.","IT4090002_MAR_Coe_L001","","Rio 1","15.15","16.25","sole","sole","28","","brezza, forza 3/4","20-30","elevata, fino al fondo","14 a monte","18 a valle","","","seminativo a grano attorno, ombreggiamento alberi e arbusti e Arundo donax","0","0","CMR","73","1","0","74","","","","varie","idem","","0","0","0","0","0","0","73AMm, 1AMf","","",""},
			{"006EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","27/05/2016","Fabbri R.","IT4090002_MAR_Coe_L001","","Rio 1","16.32","16.46","sole","sole","28","","brezza, forza 3/4","20-30","elevata, fino al fondo","14 a monte","18 a valle","","","seminativo a grano attorno, ombreggiamento alberi e arbusti e Arundo donax","0","0","CMR","58","6","0","64","","","","varie","idem","","0","0","0","0","0","0","38AMm, 3Ajm","","",""},
			{"007EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","03/06/2016","Ecosistema","IT4090002_MAR_Coe_L001","","Rio 1","","","sole","sole","","","","","","","","","","","0","0","CMR","234","6","0","240","","","ricattura di 1 maschio marcato nel Rio1 il 27mag16","","","","0","0","0","0","0","0","228AMm, 6Ajm, 6AMf","","",""},
			{"008EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","15/06/2016","Fabbri R. & Monterastelli E.","IT4090002_MAR_Coe_L001","","Rio 1","12.45","16.20","sole","sole","24-26","","sostenuto, direz. NE","20-30","elevata, fino al fondo","","19 a valle","7.74 a valle","460","nutria, ombreggiamento arbusti","0","0","CMR","148","7","0","155","","","","12","tutti AM: Ceriagrion tenellum 50, Orthetrum brunneum 10, Orthetrum coerulescens 10, Calopteryx splendens 10, Calopteryx haemorrhoidalis 10, Platycnemis pennipes 30, Coenagrion puella 15, Ischnura elegans 40; Sympetrum striolatum AI 1m juv.","monitoraggio specie solo su sponda sx causa vento sostenuto","0","0","0","0","0","0","115AMm, 1Ajm, 7AMf","31AMm, 1Ajm","",""},
			{"009EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","25/06/2016","Ecosistema","IT4090002_MAR_Coe_L001","","Rio 1","9.20","12.06","sole","sole","27-30","","assente, muove solo qualche foglia","20-30","elevata, fino al fondo","14 a monte","19,5/20 a valle","7.03 a monte-7.70/7.80 a valle","700 a monte-680/710 a valle","seminativo a grano attorno, ombreggiamento alberi e arbusti e Arundo donax","0","0","VES","10","0","0","10","","","","varie","tutti AM: Ceriagrion tenellum >100 anche juv., Orthetrum brunneum >20, Orthetrum coerulescens >20, Calopteryx splendens >30, Calopteryx haemorrhoidalis >30, Platycnemis pennipes >100, Coenagrion puella 3m e 1copula, Ischnura elegans 1m e 1coppia, Ischnura pumilio 10es. e coppie, Sympetrum striolatum 5 juv.","quando la temperatura  salita sopra i 29C gli adulti hanno cessato attivit e hanno ripreso dopo le 14.30","0","0","0","0","0","0","110AMm, 1Ajm, 2AMf","51AMm, 1Ajm, 6AMf","2AMm, 1Ajm",""},
			{"009EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","25/06/2016","Ecosistema","IT4090002_MAR_Coe_L001","","Rio 1","12.07","12.22","sole","sole","27-30","","assente, muove solo qualche foglia","20-30","elevata, fino al fondo","14 a monte","19,5/20 a valle","7.03 a monte-7.70/7.80 a valle","700 a monte-680/710 a valle","idem","0","0","CMR","166","8","0","174","","","ricattura di 4 maschi marcati nel Rio1 il 15giu16","varie","idem","quando la temperatura  salita sopra i 29C gli adulti hanno cessato attivit e hanno ripreso dopo le 14.30","0","0","0","0","0","0","10AMm","","",""},
			{"009EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","25/06/2016","Ecosistema","IT4090002_MAR_Coe_L001","","Rio 1","12.23","12.35","sole","sole","27-30","","assente, muove solo qualche foglia","20-30","elevata, fino al fondo","14 a monte","19,5/20 a valle","7.03 a monte-7.70/7.80 a valle","700 a monte-680/710 a valle","idem","0","0","VES","38","0","0","38","","","","varie","idem","quando la temperatura  salita sopra i 29C gli adulti hanno cessato attivit e hanno ripreso dopo le 14.30","0","0","0","0","0","0","36AMm, 2Ajm","","",""},
			{"010EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","06/07/2016","Ecosistema","IT4090002_MAR_Coe_L001","","Rio 1","","","sole","","","","","","","","","","","","0","0","CMR","92","3","0","95","","","","","","","0","0","0","0","0","0","88AMm, 4Ajm, 3AMf","","",""},
			{"011EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","17/07/2016","Ecosistema","IT4090002_MAR_Coe_L001","","Rio 1","9.30","12.00","sole","","20-22 (notte 16)","","brezza leggera","30 (rigagnolo 10)","elevata","14","17 (rigagnolo 16,8)","7,82 (rigagnolo 8,05)","720 (rigagnolo 710)","","0","0","VES","8","0","0","8","","","0","varie","tutti AM: Ceriagrion tenellum >50 anche juv., Orthetrum brunneum >30, Orthetrum coerulescens >20, Calopteryx haemorrhoidalis >30, Platycnemis pennipes >20, Coenagrion puella 1m, Chalcolestes viridis 1m juv, Ischnura pumilio 30es. anche var. auranthiaca, Sympetrum striolatum 2m juv., Barbo nel terzo rio almeno 20 es. con foto","arrivato alle 8.40 ma fino alle 9.30 gli esemplari di C. mercuriale non hanno iniziato attivit","0","0","0","0","0","0","8AMm","","",""},
			{"0001EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","06/04/2017","Fabbri R.","IT4090002_MAR_Coe_L002","588","Rio 2","15:00","17:20","sole","sole 20%","20","","","","elevata","14","15","7,71","680","Nutrie, vegetazione arborea e arbustiva in esubero","0","0","VES","2","0","0","2","","","","varie","","","0","0","0","0","0","0","2AIm","","",""},
			{"0002EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","13/04/2017","Fabbri R. & Poloni R.","IT4090002_MAR_Coe_L002","508","Rio 2","15:00","17:20","sole","parz.nuvoloso 20%","20","","","","elevata","14","15","7,71","680","Nutrie, vegetazione arborea e arbustiva in esubero","0","0","VES","24","1","0","25","","","","varie","","","0","0","0","0","0","0","","","",""},
			{"0006EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","05/05/2017","Fabbri R. & Poloni R.","IT4090002_MAR_Coe_L002","","Rio 2","10.30","13:30","sole","sole","23,5","","medio, NO 3,4 m/s","25 max","elevata","14","17","7,85","730","","0","0","VES","74","27","0","101","","","","varie","Libellula depressa 1AMf, Orthethrum coerulescens 1AIf","","0","0","0","0","0","2","","","18AMm, 4AIm, 1AIf","2AMm"},
			{"0008EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","11/05/2017","Fabbri R., Poloni R. & Ruocco M.","IT4090002_MAR_Coe_L002","","Rio 2","11:15","15:15","parzialmente nuvoloso 40%","sole 0%","22","","0,3-2,7 m/s","20 max","elevata","14","17,5","8,01","660","","0","0","VES","9","4","0","13","","","","varie","","","0","0","0","0","0","0","30AMm, 24AIm, 10AMf, 10AIf","5AMm, 7AIm, 3AMf, 2AIf","","7AMm, 1AIm, 2AMf"},
			{"0011EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","18/05/2017","Poloni R.","IT4090002_MAR_Coe_L002","","Rio 2","16:30","18:30","","sole 0%","21,0-22,0","","0,0-3,0m/s","20-30","","14","16","7,83","750","","0","0","VES","44","14","0","58","","","","varie","","","0","0","0","0","0","10","1AMm, 1AMf","1AMm, 1AIm, 3AMf, ","1AMm, 1AIm, ","3AMm, 1AIm, "},
			{"0012EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","25/05/2017","Poloni R.","IT4090002_MAR_Coe_L002","","Rio 2","10:30","15:30","sole 0%","sole 30%","25,5","","0,0-4,3 m/s NE-SO","30 max","elevata","","","","","","0","0","VES","47","5","0","52","","","","varie","","","0","0","0","0","0","1","12AMm, 1AIm, 4AMf, 1AIf","10AMm, 5AMf","8AMm, 1AIm, 3AMf, 1AIf","9AMm, 3AIm, "},
			{"0015EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","01/06/2017","Ecosistema & Poloni R.","IT4090002_MAR_Coe_L002","","Rio 2","11:00","16:00","parz. nuvoloso 70%","sole 0%","24,7 ","","0,0-3,8 m/s NE-SO","15 max","elevata","","","","","","0","0","VES","34","5","0","39","","","","varie","","","0","0","0","0","0","0","22AMm, 6AIm, 4AMf","4AMm, 1AMf","0","11AMm, 4AIm"},
			{"001EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","12/04/2016","Fabbri R.","IT4090002_MAR_Coe_L002","","Rio 2","16:30","18:00","sole ","sole 20%","26,5-28,0","","0,5-3,8 m/s","10","elevata","14","19,5","7,88","760","","0","0","VES","3","0","0","3","","","","varie","","","0","0","0","0","0","0","10AMm, 2AMf","8AMm, 2AMf","7AMm, 1AMf","8AMm, 1AIm"},
			{"0020EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","12/06/2017","Ecosistema & Poloni R.","IT4090002_MAR_Coe_L002","","Rio 2","17:00","19:15","sole 0%","sole 0%","27,0-31,0","","0,3-3,7 m/s","10","elevata","17,5","21,5","7,91","630","","0","0","VES","23","13","0","36","","","","varie","","","0","0","0","0","0","0","2AMm, 3AMf","13AMm, 7AMf","5AMm, 1AIm, 3AMf","2AMm"},
			{"0022EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","20/06/2017","Ecosistema & Poloni R.","IT4090002_MAR_Coe_L002","","Rio 2","15:30","18:00","sole 0%","sole 0%","29,5","","0,0-2,6 m/sec","10","elevata","19,5","22","7,79","700","","0","0","VES","3","4","0","7","","","","varie","","","0","0","0","0","0","0","1AMm, 4AMf","0","1AMm","1AMm"},
			{"0024EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","01/07/2017","Ecosistema & Poloni R.","IT4090002_MAR_Coe_L002","","Rio 2","14:30","17:30","sole 30%","sole","27,5","","0,0-3,2 m/sec - NE","10","elevata","20","24","7,92-8,05","650-800","","0","0","VES","4","0","0","4","","","","varie","","","0","0","0","0","0","0","2AMm","2AMm","0","0"},
			{"0025EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","06/07/2017","Ecosistema & Poloni R.","IT4090002_MAR_Coe_L002","","Rio 2","17:00","18:15","sole 0%","sole","31,5","","0,0-0,9 m/sec - NE","10","elevata","14","20,5","7,40-7,94","700-640","","0","0","VES","0","0","0","0","","","","varie","","","0","0","0","0","0","0","0","0","0","0"},
			{"0026EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","15/07/2017","Ecosistema","IT4090002_MAR_Coe_L002","","Rio 2","08:45","11:07","sole 20%","sole","26,5","","0,0-2,7 m/sec - NE","10","elevata","14","19,5","7,40-8,04","700-790","","0","0","VES","1","4","0","5","","","","varie","","","0","0","0","0","0","0","1AMf","2AMf","1AMm, 1AMf","0"},
			{"0027EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","21/07/2017","Ecosistema & Aguzzi S.","IT4090002_MAR_Coe_L002","","Rio 2","09:15","11:00","sole 0%","sole","27","","0,0-1,8 m/sec - NE","10","elevata","14","20","8","790","","0","0","VES","1","1","0","2","","","","varie","","","0","0","0","0","0","0","0","1AMm","0","1AMf"},
			{"0028EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","26/07/2017","Ecosistema","IT4090002_MAR_Coe_L002","","Rio 2","08:30","10:15","sole 0%","sole","26","","","10","elevata","14","21","","","","0","0","VES","0","0","0","0","","","","varie","","","0","0","0","0","0","0","0","0","0","0"},
			{"002EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","19/04/2016","Fabbri R.","IT4090002_MAR_Coe_L002","","Rio 2","","","sole","sole","","","","","","","","","","","0","0","VES","11","1","0","12","","","","","","","0","0","0","0","0","0","1AMm, 2Ajm","","",""},
			{"003EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","28/04/2016","Fabbri R.","IT4090002_MAR_Coe_L002","","Rio 2","","","sole","sole","","","","","","","","","","","0","0","VES","13","1","0","14","","","","","","","0","0","0","0","0","0","4AMm, 7Ajm, 1AMf","","",""},
			{"004EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","06/05/2016","Fabbri R.","IT4090002_MAR_Coe_L002","","Rio 2","","","sole","sole","","","","","","","","","","","0","0","VES","23","1","0","24","","","","","","","0","0","0","0","0","0","10AMm, 3Ajm, 1AMf","","",""},
			{"005EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","12/05/2016","Fabbri R.","IT4090002_MAR_Coe_L002","","Rio 2","","","sole","sole","","","","","","","","","","","0","0","VES","33","2","0","35","","","","","","","0","0","0","0","0","0","20AMm, 3Ajm, 1AMf","","",""},
			{"006EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","27/05/2016","Fabbri R.","IT4090002_MAR_Coe_L002","","Rio 2","","","sole","sole","","","","","","","","","","","0","0","VES","43","0","0","43","","","","","","","0","0","0","0","0","0","30AMm, 3Ajm, 2AMf","","",""},
			{"006EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","27/05/2016","Fabbri R.","IT4090002_MAR_Coe_L002","","Rio 2","16.52","17.06","sole","sole","28","","brezza, forza 3/4","20-30","elevata, fino al fondo","","","","","seminativo a grano attorno, ombreggiamento alberi e arbusti e Arundo donax","0","0","VES","31","1","0","32","","","","varie","idem","","0","0","0","0","0","0","29AMm, 2Ajm, 1AMf","","",""},
			{"007EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","03/06/2016","Ecosistema","IT4090002_MAR_Coe_L002","","Rio 2","17.31","17.42","sole","sole","28","","brezza, forza 3/4","20-30","elevata, fino al fondo","","","","","seminativo a grano attorno, ombreggiamento alberi e arbusti e Arundo donax","0","0","VES","33","1","0","34","","","ricattura di 2 maschi marcati nel Rio1 e ripresi nel Rio2 dopo circa 3 ore a circa 190m di distanza","varie","idem","","0","0","0","0","0","0","42AMm, 1Ajm","","",""},
			{"008EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","15/06/2016","Fabbri R. & Monterastelli E.","IT4090002_MAR_Coe_L002","","Rio 2","","","sole","sole","","","","","","","","","","","0","0","VES","46","3","0","49","","","","","","","0","0","0","0","0","0","33AMm, 1AMf","","",""},
			{"009EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","25/06/2016","Ecosistema","IT4090002_MAR_Coe_L002","","Rio 2","12.45","16.20","sole","","24-26","","sostenuto, direz. NE","20-30","elevata, fino al fondo","","16,5 a valle","7.75 a valle","490","ombreggiamento alberi e arbusti","0","0","VES","7","0","0","7","","","","6","tutti AM: Ceriagrion tenellum 10, Orthetrum brunneum 10, Orthetrum coerulescens 5, Calopteryx splendens 20, Calopteryx haemorrhoidalis 30, Platycnemis pennipes 30, Ischnura elegans 3","monitoraggio specie solo su sponda sx causa vento sostenuto","0","0","0","0","0","0","14AMm, 1AMf","25AMm, 1Ajm","29AMm, 2Ajm, 3AMf",""},
			{"009EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","25/06/2016","Ecosistema","IT4090002_MAR_Coe_L002","","Rio 2","12.38","12.48","sole","","30-34","","assente, muove solo qualche foglia","20-30","elevata, fino al fondo","","","","","idem","0","0","VES","8","0","0","8","","","","varie","idem","quando la temperatura  salita sopra i 29C gli adulti hanno cessato attivit e hanno ripreso dopo le 14.30","0","0","0","0","0","0","7AMm","","",""},
			{"010EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","06/07/2016","Ecosistema","IT4090002_MAR_Coe_L002","","Rio 2","12.58","13.08","sole","","30-34","","assente, muove solo qualche foglia","20-30","elevata, fino al fondo","","","","","idem","0","0","VES","10","1","0","11","","","","varie","idem","quando la temperatura  salita sopra i 29C gli adulti hanno cessato attivit e hanno ripreso dopo le 14.30","0","0","0","0","0","0","8AMm","","",""},
			{"011EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","17/07/2016","Ecosistema","IT4090002_MAR_Coe_L002","","Rio 2","","","sole","","","","","","","","","","","","0","0","VES","0","0","0","0","","","","","","","0","0","0","0","0","0","10AMm, 1AMf","","",""},
			{"012EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","08/08/2016","Ecosistema","IT4090002_MAR_Coe_L002","","Rio 2","9.30","12.00","sole","","20-22 (notte 16)","","brezza leggera","30","elevata","14","17","7,82","720","","0","0","VES","0","0","0","0","","","","","","","0","0","0","0","0","0","","","",""},
			{"013EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","23/08/2016","R. Fabbri & L. Casini","IT4090002_MAR_Coe_L002","","Rio 2","16.00","17.20","sole","","25","","brezza molto leggera","","","14","20","","","","0","0","VES","0","0","0","0","","","","","","","0","0","0","0","0","0","","","",""},
			{"0001EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","06/04/2017","Fabbri R.","IT4090002_MAR_Coe_L003","","Rio 3","11.00","12.30","sole","","26","","brezza molto leggera","","","14","rio 2: 18,5","","","","0","0","VES","0","0","0","0","","","","","","","0","0","0","0","0","0","","","",""},
			{"0002EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","13/04/2017","Fabbri R. & Poloni R.","IT4090002_MAR_Coe_L003","","Rio 3","10.30","13:30","sole","","23,5","","NO 3,4 m/s","25 max","elevata","14","17","7,85","730","","0","0","VES","6","2","0","8","","","","varie","Ceriagrion tenellum 1AIm","","0","0","0","0","0","0","1AMm, 4AIm, 2AIf","1AIm","",""},
			{"0006EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","05/05/2017","Fabbri R. & Poloni R.","IT4090002_MAR_Coe_L003","","Rio 3","11:15","15:15","parzialmente nuvoloso 40%","","22","","0,3-2,7 m/s","20 max","elevata","14","17,5","8,01","660","","0","0","VES","41","15","0","56","","","","varie","","","0","0","0","0","0","0","2AMm, 20AIm, 2AMf, 3AIf","3AMm, 16AIm, 2AMf, 8AIf","",""},
			{"0008EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","11/05/2017","Fabbri R., Poloni R. & Ruocco M.","IT4090002_MAR_Coe_L003","","Rio 3","16:30","18:30","","","21,0-22,0","","0,0-3,0m/s","20-30 max","","14","16","7,83","750","","0","0","VES","39","15","0","54","","","","varie","","","0","0","0","0","0","0","24AMm, 5AIm, 4AMf, 7AIf","7AMm, 3AIm, 4AMf","",""},
			{"0011EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","18/05/2017","Poloni R.","IT4090002_MAR_Coe_L003","","Rio 3","10:30","15:30","sole 0%","","25,5","","0,0-4,3 m/s NE-SO","30 max","elevata","","","","","","0","0","VES","11","6","0","17","","","","varie","","","0","0","0","0","0","2","5AMm, 2AMf","6AMm, 1AMf, 3AIf","",""},
			{"0012EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","25/05/2017","Poloni R.","IT4090002_MAR_Coe_L003","","Rio 3","11:00","16:00","parz. nuvoloso 70%","","24,7 ","","0,0-3,8 m/s NE-SO","15 max","elevata","","","","","","0","0","VES","12","2","0","14","","","","varie","","","0","0","0","0","0","1","5AMm","4AMm, 3AIm, 2Amf","",""},
			{"0015EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","01/06/2017","Ecosistema & Poloni R.","IT4090002_MAR_Coe_L003","","Rio 3","16:30","18:00","sole ","","26,5-28,0","","0,5-3,8 m/s","10","elevata","14","19,5","7,88","760","","0","0","VES","26","3","0","29","","","","varie","","","0","0","0","0","0","0","3AMm, 1AMf","19AMm, 4AIm, 2AMf","",""},
			{"001EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","12/04/2016","Fabbri R.","IT4090002_MAR_Coe_L003","","Rio 3","17:00","19:15","sole 0%","","27,0-31,0","","0,3-3,7 m/s","10","elevata","17,5","21,5","7.91","630","","0","0","VES","2","0","0","2","","","","varie","","","0","0","0","0","0","0","3AMm, 1AIm, 3AMf","6AMm, 8AIm, 7AMf","",""},
			{"0020EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","12/06/2017","Ecosistema & Poloni R.","IT4090002_MAR_Coe_L003","","Rio 3","15:30","18:00","sole 0%","","29,5","","0,0-2,6 m/sec","10","elevata","19,5","22","7,79","700","","0","0","VES","18","10","0","28","","","","varie","","","0","0","0","0","0","0","1AMf","7AMm, 1AMf","",""},
			{"0022EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","20/06/2017","Ecosistema & Poloni R.","IT4090002_MAR_Coe_L003","","Rio 3","14:30","17:30","sole 30%","","27,5","","0,0-3,2 m/sec - NE","10","elevata","20","24","7,92-8,05","650-800","","0","0","VES","7","2","0","9","","","","varie","","","0","0","0","0","0","0","0","1AMf","",""},
			{"0024EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","01/07/2017","Ecosistema & Poloni R.","IT4090002_MAR_Coe_L003","","Rio 3","17:00","18:15","sole 0%","","31,5","","0,0-0,9 m/sec - NE","10","elevata","14","20,5","7,40-7,94","700-640","","0","0","VES","0","1","0","1","","","","varie","","","0","0","0","0","0","0","0","3AMm, 2AMf","",""},
			{"0025EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","06/07/2017","Ecosistema & Poloni R.","IT4090002_MAR_Coe_L003","","Rio 3","08:45","11:07","sole 20%","","26,5","","0,0-2,7 m/sec - NE","10","elevata","14","19,5","7,40-8,04","700-790","","0","0","VES","3","2","0","5","","","","varie","","","0","0","0","0","0","0","0","2AMm, 1AIm, 1AMf","",""},
			{"0026EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","15/07/2017","Ecosistema","IT4090002_MAR_Coe_L003","","Rio 3","09:15","11:00","sole 0%","","27","","0,0-1,8 m/sec - NE","10","elevata","14","20","8","790","","0","0","VES","3","1","0","4","","","","varie","","","0","0","0","0","0","1","0","2AMf","",""},
			{"0027EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","21/07/2017","Ecosistema & Aguzzi S.","IT4090002_MAR_Coe_L003","","Rio 3","08:30","10:15","sole 0%","","26","","","10","elevata","14","21","","","","0","0","VES","0","2","0","2","","","","varie","","","0","0","0","0","0","0","0","0","0","0"},
			{"0028EC17-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","26/07/2017","Ecosistema","IT4090002_MAR_Coe_L003","","Rio 3","","","sole","","","","","","","","","","","","0","0","VES","0","0","0","0","","","","","","","0","0","0","0","0","0","1AMm, 1Ajm","","",""},
			{"002EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","19/04/2016","Fabbri R.","IT4090002_MAR_Coe_L003","","Rio 3","","","sole","","","","","","","","","","","","0","0","VES","7","0","0","7","","","","","","","0","0","0","0","0","0","3AMm, 4Ajm","","",""},
			{"003EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","28/04/2016","Fabbri R.","IT4090002_MAR_Coe_L003","","Rio 3","","","sole","","","","","","","","","","","","0","0","VES","10","1","0","11","","","","","","","0","0","0","0","0","0","7AMm, 3Ajm, 1AMf","","",""},
			{"004EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","06/05/2016","Fabbri R.","IT4090002_MAR_Coe_L003","","Rio 3","","","sole","","","","","","","","","","","","0","0","VES","14","3","0","17","","","","","","","0","0","0","0","0","0","9AMm, 5Ajm, 3AMf","","",""},
			{"005EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","12/05/2016","Fabbri R.","IT4090002_MAR_Coe_L003","","Rio 3","","","sole","","","","","","","","","","","","0","0","VES","27","3","0","30","","","","","","","0","0","0","0","0","0","26AMm, 1Ajm, 3AMf","","",""},
			{"006EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","27/05/2016","Fabbri R.","IT4090002_MAR_Coe_L003","","Rio 3","17.12","17.22","sole","","28","","brezza, forza 3/4","20-30","elevata, fino al fondo","14","15,5 a valle rio","","","seminativo a grano attorno, ombreggiamento alberi e arbusti e Arundo donax","0","0","VES","28","4","0","32","","","","varie","idem","","0","0","0","0","0","0","26AMm, 2Ajm, 4AMf","","",""},
			{"007EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","03/06/2016","Ecosistema","IT4090002_MAR_Coe_L003","","Rio 3","","","sole","","","","","","","","","","","","0","0","VES","15","2","0","17","","","","","","","0","0","0","0","0","0","15AMm, 2AMf","","",""},
			{"008EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","15/06/2016","Fabbri R. & Monterastelli E.","IT4090002_MAR_Coe_L003","","Rio 3","12.45","16.20","sole","","24-26","","sostenuto, direz. NE","20-30","elevata, fino al fondo","","16,5 a valle","7.75 a valle","490","ombreggiamento alberi e arbusti","0","0","VES","11","1","0","12","","","","5","tutti AM: Ceriagrion tenellum 2, Orthetrum brunneum 10, Orthetrum coerulescens 5, Calopteryx splendens 5, Calopteryx haemorrhoidalis 10, Platycnemis pennipes 50, Coenagrion puella 15, Ischnura elegans 3","monitoraggio specie solo su sponda sx causa vento sostenuto","0","0","0","0","0","0","9AMm, 2Ajm, 1AMf","","",""},
			{"009EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","25/06/2016","Ecosistema","IT4090002_MAR_Coe_L003","","Rio 3","12.49","12.56","sole","","30-34","","assente, muove solo qualche foglia","20-30","elevata, fino al fondo","","","","","idem","0","0","VES","1","0","0","1","","","","varie","idem","quando la temperatura  salita sopra i 29C gli adulti hanno cessato attivit e hanno ripreso dopo le 14.30","0","0","0","0","0","0","1Ajm","","",""},
			{"010EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","06/07/2016","Ecosistema","IT4090002_MAR_Coe_L003","","Rio 3","","","sole","","","","","","","","","","","","0","0","VES","5","0","0","5","","","","","","","0","0","0","0","0","0","5AMm, ","","",""},
			{"011EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","17/07/2016","Ecosistema","IT4090002_MAR_Coe_L003","","Rio 3","9.30","12.00","sole","","20-22 (notte 16)","","brezza leggera","30","elevata","14","17","7,82","720","","0","0","VES","0","0","0","0","","","","","","","0","0","0","0","0","0","","","",""},
			{"012EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","08/08/2016","Ecosistema","IT4090002_MAR_Coe_L003","","Rio 3","16.00","17.20","sole","","25","","brezza molto leggera","","","14","20","","","","0","0","VES","0","0","0","0","","","","","","","0","0","0","0","0","0","","","",""},
			{"013EC16-CoeS","Coenagrion mercuriale castellanii","MAR","IT4090002 Torriana, Montebello, Fiume Marecchia","23/08/2016","R. Fabbri & L. Casini","IT4090002_MAR_Coe_L003","","Rio 3","11.00","12.30","sole","","26","","brezza molto leggera","","","14","","","","","0","0","VES","0","0","0","0","","","","","","","0","0","0","0","0","0","","","",""},
			{"0001DM16","Coenagrion mercuriale castellanii","MEC","Fuori SIC","03/08/2016","Malavasi D.","FuoriSIC_MEC_Coe_L002","44,43483","ruscelli","","","","","","","","","","","","","","","44,43483","10,76568","","0","0","0","0","","","","","","","0","0","0","0","0","0","","","",""},
			{"0002DM16","Coenagrion mercuriale castellanii","MEC","IT4040013 Faeto, Varana, Torrente Fossa","03/08/2016","Malavasi D.","IT4040013_MEC_Coe_L003","44,30794","Torrente Lerna","20:40","","","","","","","","","","","","","","44,30794","10,86143","","0","0","0","0","","","","","","","0","0","0","0","0","0","","","",""},
			{"0001SS17","Coenagrion mercuriale castellanii","MEC","IT4030018 Media Val Tresinaro, Val Dorgola","14/03/2017","Stefanelli S. & Malavasi D.","IT4030018_MEC_Coe_L001","44,489416","Rio Dorgola","13:39","","","","","","","","","","","","","","44,489416","10,569098","","0","0","0","0","","","","","","","0","0","0","0","0","0","","","",""},
			{"001DM17","Coenagrion mercuriale castellanii","MEOC","IT4020017 Aree Risorgive Viarolo, Torrile","08/05/2017","Malavasi D.","IT4020017_MEOC_Coe_L001","44,88722","Fontanile Viarolo","","","","","","","","","","","","","","","44,88722","10,2825","","0","0","0","0","Phragmites","","","","","","0","0","0","0","0","0","","","",""},
			{"002DM17","Coenagrion mercuriale castellanii","MEOC","IT4020017 Aree Risorgive Viarolo, Torrile","08/05/2017","Malavasi D.","IT4020017_MEOC_Coe_L002","44,88555","Lorno","","","","","","","","","","","","","","","44,88555","10,28138","","0","0","0","0","","","","","","","0","0","0","0","0","0","","","",""},
			{"003DM17","Coenagrion mercuriale castellanii","MEOC","IT4020017 Aree Risorgive Viarolo, Torrile","10/05/2017","Malavasi D.","IT4020017_MEOC_Coe_L003","44,87694","","","","","","","","","","","","","","","","44,87694","10,28194","","0","0","0","0","","","","","","","0","0","0","0","0","0","","","",""},
			{"1EM16","Coenagrion mercuriale castellanii","MEOR","FuoriSIC","16/06/2016","Monterastelli E.","FuoriSIC_MEOR_Coe_L007","2800","Rio Di Quercia Buca","16:20","","","","","","","","","","","","","vedi scheda habitat","44,39665","11,394493","VES, CMR","0","0","0","0","","","","","Specie viste:Sympetrum sp. (2,m), Orthetrum cancellatum (3, m), Platycnemis pennipes (> 10, m/f)","","0","0","0","0","0","0","","","",""},
			{"2EM16","Coenagrion mercuriale castellanii","MEOR","IT4050003 Monte Sole","23/06/2016","Monterastelli E., Maini G.","IT4050003_MEOR_Coe_L011","","Rio Ca' di Durino","12:45","","","","","","","","","","","","","vedi scheda habitat","44,298688","11,201832","VES, CMR","0","0","0","0","","","","","Specie viste: Calopteryx virgo (4, m/f), girini di Pelophylax esculentus ?","","0","0","0","0","0","0","","","",""},
			{"3EM16","Coenagrion mercuriale castellanii","MEOR","FuoriSIC","06/07/2016","Monterastelli E.","FuoriSIC_MEOR_Coe_L020","2200","Rio Gorgara","13:40","","","","","","","","","","","","","vedi scheda habitat","44,432791","11,497097","VES, CMR","0","0","0","0","","","","","Specie viste: Aeshna affinis (1,m), Platycnemis pennipes (>20, m/f, 6 copule), Orthetrum brunneum (>10, m/f, 2 copule), Orthetrum coerulescens (<5, m/f, 1 copula), Calopterix haemorrhoidalis (> 10, m/f), Ischnura elegans (4,m)","","0","0","0","0","0","0","","","",""},
			{"4EM16","Coenagrion mercuriale castellanii","MEOR","IT4050012 Contrafforte Pliocenico","21/07/2016","Monterastelli E., Nigro F.","IT4050012_MEOR_Coe_L031","","Fonte Dell'Assassino","14:15","","","","","","","","","","","","","vedi scheda habitat","44,341724","11,319495","VES, CMR","0","0","0","0","","","","","Specie viste: Platycnemis pennipes (1,f)","","0","0","0","0","0","0","","","",""},
			{"5EM16","Coenagrion mercuriale castellanii","MEOR","FuoriSIC","26/07/2016","Monterastelli E., Nigro F.","FuoriSIC_Coe_L032","1186","Rio Gemmese","14:30","","","","","","","","","","","","","vedi scheda habitat","44,391686","11,243084","VES, CMR","0","0","0","0","","","","","Specie viste: Calopteryx haemorrhoidalis(> 20,m/f), Cordulegaster boltonii (<10, m/f), Morimus asper (1, f)","","0","0","0","0","0","0","","","",""},
			{"6EM16","Coenagrion mercuriale castellanii","MEOR","FuoriSIC","26/07/2016","Monterastelli E., Nigro F.","FuoriSIC_Coe_L034","","Rio Raibano (Valle)","16:05","","","","","","","","","","","","","vedi scheda habitat","44,368704","11,259413","VES, CMR","0","0","0","0","","","","","Specie viste: Calopteryx haemorrhoidalis (5, m/f)","","0","0","0","0","0","0","","","",""},
			{"7EM16","Coenagrion mercuriale castellanii","MEOR","IT4050003 Monte Sole","09/08/2016","Monterastelli E.","IT4050003_MEOR_Coe_L042","","Rio Via Co Di Berto","18:30","","","","","","","","","","","","","vedi scheda habitat","44,32312","11,255442","VES, CMR","0","0","0","0","","","","","","","0","0","0","0","0","0","","","",""},
			{"0001MN16-CoeS","Coenagrion mercuriale castellanii","PNFC","Fuori SIC","09/07/2016","Fabbri R., Laurens E.","FuoriSIC_PNFC_Coe_L001","300","Fosso di Bagno","17.30","18.00","sereno","sereno","26.0","51","1.0","10","elevata, >30cm","18","18","8.30","430","scarsa vegetazione acquatica, trote, pascolamento pecore lungo sponede del primo tratto","44,04438","11,71984","VES","0","0","0","0","","","","varie","Calopteryx splendens 10 es., Calopteryx virgo 30 es., ","transetto fuori Sic di circa 300 m","","","","","","","","","",""},
			{"0001ST17-CoeS","Coenagrion mercuriale castellanii","PNFC","Fuori SIC","09/06/2017","Sterna","FuoriSIC_PNFC_Coe_L002","600","Fosso di Bagno","17.00","18.00","sereno","sereno","24.0","45","0.7","10","elevata, >30cm","16.0","16.5","8.45","460","scarsa vegetazione acquatica, trote, pascolamento pecore lungo sponede del primo tratto","44,04444","11,71986","VES","0","0","0","0","","","","varie","Calopteryx splendens 10 es.","","","","","","","","","","",""}

			
	};
	
	public static String[][] GRAPHODERUS() {
		
			String [][] ss = {
			{"0016SS17","","MEC","IT4040001","21/09/2017","Stefanelli S., Malavasi D., Fabbri R. et al.","IT4040001_MEC_Gr_P08","Lago Pratignano","11.15","14.00","sereno 0%","sereno 0%","1","scarsa (10 cm)","10 C (a 15cm), 10 C (a 100cm)","19","6,20","50","","44,175063","10,818145","","1","0","0","","","0","","","","","","","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0016SS17","","MEC","IT4040001","21/09/2017","Stefanelli S., Malavasi D., Fabbri R. et al.","IT4040001_MEC_Gr_P09","Lago Pratignano","11.15","14.00","sereno 0%","sereno 0%","2","media (50 cm)","9,5 C (a 15cm), 9,5 C (a 100cm)","19","","","","44,174915","10,81824","","1","0","0","","","0","","","","","larve Anisotteri, Notonecte, rana verde ","da sfangare","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0016SS17","","MEC","IT4040001","21/09/2017","Stefanelli S., Malavasi D., Fabbri R. et al.","IT4040001_MEC_Gr_P11","Lago Pratignano","11.15","14.00","sereno 0%","sereno 0%","1","media (50 cm)","","19","6,30","60","","44,175976","10,818551","","1","0","0","","","0","","","","","Tritone punteggiato, rana verde, Notonecte, larve Anisotteri, 2 Agabus sp1","","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0003RF17","","MEC","IT4040001","21/09/2017","Fabbri R. et al.","IT4040001_MEC_Gr_P02","Lago Pratignano","10.30","14.30","sereno 0%","sereno 0%","1","elevata (70 cm)","","6,5-15","","","","44,175765","10,818347","","2","0","0","","","0","","","","","larve Anisotteri, Notonecte, 2 Agabus sp1","","N-0","N-0","","","","","","","","","","","","","","","","","",""},
			{"0003RF17","","MEC","IT4040001","21/09/2017","Fabbri R. et al.","IT4040001_MEC_Gr_P03","Lago Pratignano","10.30","14.30","sereno 0%","sereno 0%","2,5","elevata (70 cm)","11 C (a 15cm), 10 C (a 200cm)","6,5-15","6,20","40","","44,176067","10,818464","","5","0","0","","","0","","","","","larve Anisotteri, Notonecte, Triturus crestato, 2 Rana verde , 2 Tinca ","","N-0","N-0","N-0","N-0","N-0","","","","","","","","","","","","","","",""},
			{"0003RF17","","MEC","IT4040001","21/09/2017","Fabbri R. et al.","IT4040001_MEC_Gr_P05","Lago Pratignano","10.30","14.30","sereno 0%","sereno 0%","1,5","elevata (70 cm)","","6,5-15","","","","44,174989","10,818122","","2","0","0","","","0","","","","","Triturus crestato, rana verde , 2 Agabus sp1., 2 Agabus sp2 , 5 Dytiscus marginalis (2m 3f ) , Hydroporus sp1","","N-0","N-0","","","","","","","","","","","","","","","","","",""},
			{"0003RF17","","MEC","IT4040001","21/09/2017","Fabbri R. et al.","IT4040001_MEC_Gr_P10","Lago Pratignano","10.30","14.30","sereno 0%","sereno 0%","1,5","scarsa (30 cm)","","6,5-15","","","","44,17509","10,81866","","1","0","0","","","0","","","","","2 rana verde, Notonecte, larve Anisotteri, Idrofilidi","","N-0","","","","","","","","","","","","","","","","","","",""},
			{"0017SS17","","MEC","IT4040001","05/10/2017","Stefanelli S. & Malavasi D.","IT4040001_MEC_Gr_P01","Lago Pratignano","11.20","15.00","sereno 0%","sereno 0%","2  2,5","scarsa (10cm)","10 C (a 15cm), 10 C (a 100cm), 10 C (a 150cm)","17,1","6,16","55,7","","44,175765","10,818347","","3","0","0","","","0","","","","","larve Anisotteri, Corixa sp., rana verde, tinca, sanguisuga, Agabus spp.","","N-0 es.","N-0 es.","N-0 es.","","","","","","","","","","","","","","","","",""},
			{"0018SS17","","MEC","IT4040001","05/10/2017","Stefanelli S., Malavasi D., Minelli F. & Fabbri R.","IT4040001_MEC_Gr_P03","Lago Pratignano","11.20","15.00","sereno 0%","sereno 0%","2,5","scarsa (30cm)","10 C (a 15cm), 10 C (a 100cm), 10 C (a 150cm)","17,1","6,30","30,2","","44,176026","10,818031","","8","0","0","","","0","","","","","Tritone crestato, larve Anisotteri, larve Efemerotteri, larve Tricotteri, 2 rana verde, 4 Dytiscus marginalis (2m 1f), 3 Agabus sp1, 6 Agabus sp2","","N-0 es.","N-0 es.","N-0 es.","N-0 es.","N-0 es.","N-0 es.","N-0 es.","N-0 es.","","","","","","","","","","","",""},
			{"0019SS17","","MEC","IT4040001","05/10/2017","Stefanelli S. & Malavasi D.","IT4040001_MEC_Gr_P04","Lago Pratignano","11.20","15.00","sereno 0%","sereno 0%","1","scarsa (10 cm)","","18","","","","44,175686","10,818053","","2","0","0","","","0","","","","","","molto fango","N-0 es.","N-0 es.","","","","","","","","","","","","","","","","","",""},
			{"0020SS17","","MEC","IT4040001","05/10/2017","Stefanelli S. & Malavasi D.","IT4040001_MEC_Gr_P06","Lago Pratignano","11.20","15.00","sereno 0%","sereno 0%","","scarsa (10 cm)","","18","","","","44,175063","10,818145","","1","0","0","","","0","","","","","","poca acqua, molto fango","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0021SS17","","MEC","IT4040001","05/10/2017","Stefanelli S., Minelli F. & Fabbri R.","IT4040001_MEC_Gr_P09","Lago Pratignano","11.20","15.00","sereno 0%","sereno 0%","1,5","scarsa (10 cm)","9 C (a 15cm), 8 C (a 100cm), 8 C (a 150cm)","18","","","","44,174989","10,818122","","1","0","0","","","0","","","","","larve Anisotteri, 2 Idrofilidi, 1 Hydroporus sp., 3 Agabus sp1., Gerridi, larve Efemerotteri, larve Tricotteri, rana verde","","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0022SS17","","MEC","IT4040001","05/10/2017","Stefanelli S. & Malavasi D.","IT4040001_MEC_Gr_P10","Lago Pratignano","11.20","15.00","sereno 0%","sereno 0%","1,5","scarsa (10 cm)","","18","","","","44,174915","10,81824","","1","0","0","","","0","","","","","","","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0023SS17","","MEC","IT4040001","05/10/2017","Stefanelli S., Malavasi D., Minelli F.","IT4040001_MEC_Gr_P11","Lago Pratignano","11.20","15.00","sereno 0%","sereno 0%","1","scarsa (10 cm)","","18","","","","44,175976","10,818551","","1","0","0","","","0","","","","","","","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0004RF17","","MEC","IT4040001","05/10/2017","Fabbri R., Minelli F.","IT4040001_MEC_Gr_P02","Lago Pratignano","11.05","17.00","sereno 0%","sereno 0%","1","media (50 cm)","","","","","","44,176067","10,818464","","2","0","0","","","0","","","","","larve Anisotteri e Zigotteri, Notonecte, 2 rana verde , Dytiscus marginalis (m), 4 Agabus sp1, 8 Agabus sp2 ","","N-0","N-0","","","","","","","","","","","","","","","","","",""},
			{"0004RF17","","MEC","IT4040001","05/10/2017","Fabbri R., Minelli F.","IT4040001_MEC_Gr_P05","Lago Pratignano","11.05","17.00","sereno 0%","sereno 0%","1,5","media (50 cm)","","","","","","44,172","10,81852","","2","0","0","","","0","","","","","larve Anisotteri e Zigotteri, Notonecte, 2 rana verde, 5 Dytiscus marginalis (3m 2f), 10 Agabus sp1, 5 Agabus sp2","","N-0","N-0","","","","","","","","","","","","","","","","","",""},
			{"0004RF17","","MEC","IT4040001","05/10/2017","Fabbri R., Stefanelli S..","IT4040001_MEC_Gr_L01","Lago Pratignano","11.05","17.00","sereno 0%","sereno 0%","0,2-0,3","scarsa (10 cm)","10 C (a 15cm)","18","","78","","44,17509","10,81866","","3","0","0","","","0","","","","","larve Efemerotteri, larve Anisotteri, Notonecte","molto fango","N-0","N-0","N-0","","","","","","","","","","","","","","","","",""},
			{"0024SS17","","MEC","IT4040001","12/10/2017","Stefanelli S. & Malavasi D.","IT4040001_MEC_Gr_P01","Lago Pratignano","11:15","11:45","sereno 20%","sereno 20%","1,4","scarsa (30cm)","8C (a 15cm), 8 C (a 100cm), 7,5 C (a 140cm)","16,2","6,20","56,7","","44,175765","10,818347","","4","0","0","","","0","","","","","larve Anisotteri, larve Zigotteri, rana verde, Corixa sp., 2 Dytiscus marginalis","meno acqua, aggallato cedevole","N-0 es.","N-0 es.","N-0 es.","N-0 es.","","","","","","","","","","","","","","","",""},
			{"0025SS17","","MEC","IT4040001","12/10/2017","Stefanelli S., Malavasi D., Minelli F. & Fabbri R.","IT4040001_MEC_Gr_P03","Lago Pratignano","12:30","13:30","sereno 10%","sereno 10%","2,5","media (25cm)","9 C (a 15cm), 9 C (a 100cm), 8C (a 150cm)","16,2","6,16","32,6","","44,176026","10,818031","","8","0","0","","","0","","","","","larve anisotteri, Tritone crestato, rana verde","","N-0 es.","N-0 es.","N-0 es.","N-0 es.","N-0 es.","N-0 es.","N-0 es.","N-0 es.","","","","","","","","","","","",""},
			{"0026SS17","","MEC","IT4040001","12/10/2017","Stefanelli S. & Malavasi D.","IT4040001_MEC_Gr_P04","Lago Pratignano","14:15","14:30","nuvoloso 50%","nuvoloso 50%","1","nulla (0 cm)","","16,2","","","","44,175686","10,818053","","2","0","0","","","0","","","","","","fango","N-0 es.","N-0 es.","","","","","","","","","","","","","","","","","",""},
			{"0027SS17","","MEC","IT4040001","12/10/2017","Stefanelli S.","IT4040001_MEC_Gr_P06","Lago Pratignano","13:30","13:40","nuvoloso 50%","nuvoloso 50%","0,5","nulla (0 cm)","","16,2","","","","44,175846","10,81785","","1","0","0","","","0","","","","","","fango","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0028SS17","","MEC","IT4040001","12/10/2017","Malavasi D.","IT4040001_MEC_Gr_P07","Lago Pratignano","13:30","13:45","nuvoloso 50%","nuvoloso 50%","1,2","nulla (0 cm)","","16,2","","","","44,175834","10,817863","","1","0","0","","","0","","","","","","fango","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0029SS17","","MEC","IT4040001","12/10/2017","Stefanelli S. & Malavasi D.","IT4040001_MEC_Gr_P08","Lago Pratignano","13:45","14:00","nuvoloso 50%","nuvoloso 50%","1","scarsa (10 cm)","","16,2","","","","44,175063","10,818145","","2","0","0","","","0","","","","","","fango","N-0 es.","N-0 es.","","","","","","","","","","","","","","","","","",""},
			{"0030SS17","","MEC","IT4040001","12/10/2017","Malavasi D.","IT4040001_MEC_Gr_P09","Lago Pratignano","11:45","12:00","sereno 20%","sereno 20%","1,4","scarsa (10 cm)","8C (a 15cm), 8C (a 100cm), 8C (a 140cm)","16,2","","","","44,174989","10,818122","","1","0","0","","","0","","","","","larve Anisotteri","","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0031SS17","","MEC","IT4040001","12/10/2017","Malavasi D.","IT4040001_MEC_Gr_P10","Lago Pratignano","12:00","12:15","sereno 20%","sereno 20%","0,6","scarsa (10 cm)","","16,2","","","","44,174915","10,81824","","1","0","0","","","0","","","","","","","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0032SS17","","MEC","IT4040001","12/10/2017","Stefanelli S.","IT4040001_MEC_Gr_P11","Lago Pratignano","11:45","12:00","sereno 20%","sereno 20%","1","scarsa (10 cm)","","16,2","","","","44,175976","10,818551","","1","0","0","","","0","","","","","larva Anisottero, Corixa sp.","","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0005RF17","","MEC","IT4040001","05/10/2017","Fabbri R., Minelli F.","IT4040001_MEC_Gr_P02","Lago Pratignano","11.00","14.00","sereno 20%","sereno 20%","1","media (50 cm)","8 C (a 15cm), 8 C (a 100cm)","15","","57","","44,176067","10,818464","","2","0","0","","","0","","","","","larve Anisotteri e Zigotteri, larve Tricotteri, rana verde , Tritone crestato, 5 Agabus sp1, 2 Agabus sp2, 4 Hydroporus sp1","","N-0","N-0","","","","","","","","","","","","","","","","","",""},
			{"0005RF17","","MEC","IT4040001","05/10/2017","Fabbri R., Minelli F.","IT4040001_MEC_Gr_P05","Lago Pratignano","11.00","14.00","sereno 20%","sereno 20%","1,5","media (50 cm)","7 C (a 15cm), 6,75 C (a 100cm)","15","","45","","44,176067","10,818464","","2","0","0","","","0","","","","","larve Anisotteri e Zigotteri, larve Efemerotteri, rana verde, 12 Dytiscus marginalis( 7m 5f), 10 Agabus sp1, 6 Agabus sp2, 20 Hydroporus sp..","","N-0","N-0","","","","","","","","","","","","","","","","","",""},
			{"0002DM17","","MEC","IT4040001","19/10/2017","Malavasi D., Carotti G., Biondi I.","IT4040001_MEC_Gr_P05","Lago Pratignano","11:00","11.30","sereno 10%","sereno 10%","1,5","scarsa (10 cm)","7C (a 15cm), 6C (a 100cm), 6C (a 150cm)","20","6,20","38","","44,175976","10,818551","","2","0","0","","","0","","","","","","","N-0 es.","N-0 es.","","","","","","","","","","","","","","","","","",""},
			{"0003DM17","","MEC","IT4040001","19/10/2017","Malavasi D.","IT4040001_MEC_Gr_P02","Lago Pratignano","11:35","12.00","sereno 10%","sereno 10%","1,5","scarsa (10 cm)","","20","","","","44,175765","10,818347","","2","0","0","","","0","","","","","larva Anisottero","","N-0 es.","N-0 es.","","","","","","","","","","","","","","","","","",""},
			{"0004DM17","","MEC","IT4040001","19/10/2017","Malavasi D., Carotti G., Biondi I.","IT4040001_MEC_Gr_P03","Lago Pratignano","12.00","12.45","sereno 10%","sereno 10%","1,7","scarsa (10 cm)","9C (a 15cm), 9C (a 100cm), 6C (a 150cm)","20","6,20","38","","44,17509","10,81866","","6","0","0","","","0","","","","","2 Dytiscus marginalis, 2 Tritone crestato, Tinca","","N-0 es.","N-0 es.","N-0 es.","N-0 es.","N-0 es.","N-0 es.","N-0 es.","","","","","","","","","","","","",""},
			{"0005DM17","","MEC","IT4040001","19/10/2017","Malavasi D., Carotti G., Biondi I.","IT4040001_MEC_Gr_P01","Lago Pratignano","13.00","13.30","sereno 10%","sereno 10%","1,7","scarsa (10 cm)","9C (a 15cm), 9C (a 100cm), 8C (a 150cm)","20","6,20","50","","44,175063","10,818145","","3","0","0","","","0","","","","","Dytiscus marginalis, Corixa sp., larva Anisottero","","N-0 es.","N-0 es.","N-0 es.","","","","","","","","","","","","","","","","",""},
			{"0006DM17","","MEC","IT4040001","19/10/2017","Malavasi D., Carotti G., Biondi I.","IT4040001_MEC_Gr_P09","Lago Pratignano","13.40","13.50","sereno 10%","sereno 10%","1,3","scarsa (10 cm)","","20","","","","44,174989","10,818122","","3","0","0","","","0","","","","","Rana esculenta","fango","N-0 es.","N-0 es.","N-0 es.","","","","","","","","","","","","","","","","",""},
			{"0006DM17","","MEC","IT4040001","19/10/2017","Malavasi D., Carotti G., Biondi I.","IT4040001_MEC_Gr_P10","Lago Pratignano","13.50","14.00","sereno 10%","sereno 10%","1","scarsa (10 cm)","","20","","","","44,174915","10,81824","","2","0","0","","","0","","","","","","fango","N-0 es.","N-0 es.","","","","","","","","","","","","","","","","","",""},
			{"0006DM17","","MEC","IT4040001","19/10/2017","Malavasi D., Carotti G., Biondi I.","IT4040001_MEC_Gr_P11","Lago Pratignano","14.05","14.15","sereno 10%","sereno 10%","1","scarsa (10 cm)","","20","","","","44,175686","10,818053","","2","0","0","","","0","","","","","","fango","N-0 es.","N-0 es.","","","","","","","","","","","","","","","","","",""},
			{"0007DM17","","MEC","IT4040001","19/10/2017","Malavasi D., Carotti G., Biondi I.","IT4040001_MEC_Gr_P06","Lago Pratignano","14.20","14.30","sereno 10%","sereno 10%","1","scarsa (10 cm)","","20","","","","44,175846","10,81785","","2","0","0","","","0","","","","","","fango","N-0 es.","N-0 es.","","","","","","","","","","","","","","","","","",""},
			{"0008DM17","","MEC","IT4040001","19/10/2017","Malavasi D., Carotti G., Biondi I.","IT4040001_MEC_Gr_P07","Lago Pratignano","14.40","14.50","sereno 10%","sereno 10%","0,8","scarsa (10 cm)","","20","","","","44,175834","10,817863","","2","0","0","","","0","","","","","","fango","N-0 es.","N-0 es.","","","","","","","","","","","","","","","","","",""},
			{"0008DM17","","MEC","IT4040001","19/10/2017","Malavasi D., Carotti G., Biondi I.","IT4040001_MEC_Gr_P08","Lago Pratignano","14.50","15.00","sereno 10%","sereno 10%","0,8","scarsa (10 cm)","","20","","","","44,176026","10,818031","","2","0","0","","","0","","","","","","fango","N-0 es.","N-0 es.","","","","","","","","","","","","","","","","","",""},
			{"0009DM17","","MEC","IT4040001","19/10/2017","Malavasi D., Carotti G., Biondi I.","IT4040001_MEC_Gr_P04","Lago Pratignano","15.00","15.15","sereno 10%","sereno 10%","0,3","scarsa (10 cm)","","20","","","","44,17509","10,81866","","2","0","0","","","0","","","","","","fango","N-0 es.","N-0 es.","","","","","","","","","","","","","","","","","",""},
			{"0001GC17","","MEC","IT4040001","26/10/2017","Carotti G.","IT4040001_MEC_Gr_P01","Lago Pratignano","","","","","","","","","6,15","45","","44,175976","10,818551","","1","0","0","","","0","","","","","","","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0001GC17","","MEC","IT4040001","26/10/2017","Carotti G.","IT4040001_MEC_Gr_P02","Lago Pratignano","","","","","","","","","","","","44,175765","10,818347","","1","0","0","","","0","","","","","","","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0001GC17","","MEC","IT4040001","26/10/2017","Carotti G.","IT4040001_MEC_Gr_P03","Lago Pratignano","","","","","","","","","6,50","55","","44,176026","10,818031","","1","0","0","","","0","","","","","","","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0001GC17","","MEC","IT4040001","26/10/2017","Carotti G.","IT4040001_MEC_Gr_P04","Lago Pratignano","","","","","","","","","","","","44,176067","10,818464","","1","0","0","","","0","","","","","","","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0001GC17","","MEC","IT4040001","26/10/2017","Carotti G.","IT4040001_MEC_Gr_P05","Lago Pratignano","","","","","","","7,2 C","","5,70","44","","44,175686","10,818053","","1","0","0","","","0","","","","","","","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0001GC17","","MEC","IT4040001","26/10/2017","Carotti G.","IT4040001_MEC_Gr_P06","Lago Pratignano","","","","","","","","","","","","44,175846","10,81785","","1","0","0","","","0","","","","","","","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0001GC17","","MEC","IT4040001","26/10/2017","Carotti G.","IT4040001_MEC_Gr_P07","Lago Pratignano","","","","","","","","","","","","44,175834","10,817863","","1","0","0","","","0","","","","","","","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0001GC17","","MEC","IT4040001","26/10/2017","Carotti G.","IT4040001_MEC_Gr_P08","Lago Pratignano","","","","","","","","","","","","44,175063","10,818145","","1","0","0","","","0","","","","","","","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0001GC17","","MEC","IT4040001","26/10/2017","Carotti G.","IT4040001_MEC_Gr_P09","Lago Pratignano","","","","","","","","","","","","44,174989","10,818122","","1","0","0","","","0","","","","","","","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0001GC17","","MEC","IT4040001","26/10/2017","Carotti G.","IT4040001_MEC_Gr_P10","Lago Pratignano","","","","","","","","","","","","44,174915","10,81824","","1","0","0","","","0","","","","","","","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"0001GC17","","MEC","IT4040001","26/10/2017","Carotti G.","IT4040001_MEC_Gr_P11","Lago Pratignano","","","","","","","","","","","","","","","1","0","0","","","0","","","","","","","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"001DM17","","MEOC","IT4020020 Crinale parmense","01/06/2017","Malavasi D.","IT4020020_MEOC_Gr_L1","Lago Verde","13.00","15.00","sereno","sereno","0,5","elevata","16","22","6.0"," -","","44,36325","10,0997","net","3 punti con net","0","0","0","0","0","distanza tra i 3 punti net circa 50-60 m","","","","Aplexa hypnorum","presenza abbondante di pesci","N-0 es.","N-0 es.","N-0 es.","","","","","","","","","","","","","","","","",""},
			{"002DM17","","MEOC","IT4020020 Crinale parmense","27/07/2017","Malavasi D.","IT4020020_MEOC_Gr_L2","Lago Verde","15.00","15.30","sereno","sereno","0,5","media","16","22","5,75"," -","","44,36325","10,0997","net","1 punto con net","0","0","0","0","0","","","","","assenza completa di insetti, anche di Odonati","presenza abbondante di pesci","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"003DM17","","MEOC","Fuori SIC","28/07/2017","Malavasi D.","FuoriSIC_MEOC_Gr_L3","Lago Moo","11.15","12.30","sereno","sereno","0,5","media","16","25,5","6.8","","16d","44,62686","9,54202","net","3 punti con net","0","0","0","0","0","","","","","Coenagrion puella, Libellula depressa, Orthetrum coerulescens, Sympetrum striolatum, Anax imperator, larve di Sialidi","eccessivo carico di bestiame e minaccia di eutrofizzazione","N-0 es.","N-0 es.","N-0 es.","","","","","","","","","","","","","","","","",""},
			{"005DM17","","MEOC","IT4020008 Monte Ragola, Lago Moo, Lago Bino","28/07/2017","Malavasi D.","IT4020008_MEOC_Gr_L4","Lago Bino maggiore","13.30","14.00","sereno","sereno","0,5","scarsa","21","26","6.8","","6 d","44,61864","9,5494","net","1 punto con net","0","0","0","0","0","","","","","Coenagrion puella","eccessivo carico di bestiame e minaccia di eutrofizzazione","N-0 es.","","","","","","","","","","","","","","","","","","",""},
			{"006DM17","","MEOC","IT4010003 Monte Nero, Monte Maggiorasca, La Ciapa Liscia","31/07/2017","Malavasi D.","IT4010003_MEOC_Gr_L5","Lago Nero","12.00","12.30","sereno","sereno","0,6","media","20","26","6.4","","<3d","44,56283","9,50258","net","2 punti con net","0","0","0","0","0","distanza tra i 3 punti net circa 30 m","","","","Libellula depressa, Coenagrion puella","presenza abbondante di pesci","N-0 es.","N-0 es.","","","","","","","","","","","","","","","","","",""},
			{"01EM16","","MEOR","IT40500015 La Martina, Monte Gurlano","05/09/2016","Monterastelli E., Fabbri R.","IT4050015_MEOR_GR_L1","Stagno La Martina n.2","11:30","18:00","sole","sole","> 3","buona","","","","","","44,216911","11,394366","net e bottle-traps","3 punti con net, 5 punti con trap e 1 con nassa","0","0","0","0","0","distanza tra trap 10 m, distanza tra i 3 punti di campionamento con retino 30 m","","","","Net: Peltodytes rotundatus (2,ex), Haliplus variegatus (2,ex), Haliplus obliquus  (2,ex), Laccophilus hyalinus (1,ex), Laccophilus minutus (8,ex), Yola bicarinata (4,ex), Triturus cristatus Visti: Bufo bufo, Pelophylax esculentus  Odonati: Sympetrum striolatum (1, m), Anax imperator (1, m), Orthetrum cancellatum (2, m/f), Crocothemis erythraea (1,m), Ischnura elegans (5, ex), Sympecma fusca (1, m), Platycnemis pennipes (1,m), Enallagma cyathigerum (> 20, m/f, copule)","","N-0","T-0","NA-0","T-0","N-0","T-0","T-0","T-0","N-0","","","","","","","","","","",""},
			{"02EM16","","MEOR","IT40500015 La Martina, Monte Gurlano","05/09/2016","Monterastelli E., Fabbri R.","IT4050015_MEOR_GR_L2","Stagno La Martina n.3","15:00","18:00","sole","sole","> 3","buona","","","","","","44,218712","11,395202","net e bottle-traps","4 punti con net e 6  punti con trap","0","0","0","0","0","distanza tra trap 10 m, distanza tra i 4 punti di campionamento con retino 30 m","","","","Net: Peltodytes rotundatus (3,ex), Laccophilus minutus (2,ex), Yola bicarinata (4,ex), Helochares lividus (1, ex) Trap: Triturus cristatus Visti: Pelophylax esculentus  Odonati: Sympetrum foscolombii (3, ex), Anax imperator (2,m), Anax parthenope (1, m), Orthetrum cancellatum (3, m/f), Ischnura elegans (3, ex), Enallagma cyathigerum (> 10, m/f)","","N-0","N-0","T-0","T-0","T-0","N-0","N-0","T-0","T-0","T-0","","","","","","","","","",""},
			{"03EM16","","MEOR","Fuori SIC - Passaggio Protetto Colline di San Luca","26/09/2016","Monterastelli E.","MEOR_GR_L3","Stagno Parco Cavaioni","14:00","18:00","sole","sole","> 1","buona","","","","","","44,227689","11,407123","bottle-traps","5 punti con trap","0","0","0","0","0","distanza tra trap 10 m ","","","","Odonati: Calcolestes sp. (3, m/f, 1 copula), Sympetrum sp. (< 10, m)","","T-0","T-0","T-0","T-0","T-0","","","","","","","","","","","","","","",""},
			{"0001IB16","","PNATE","IT4030006 Monte Prado","21/07/2016","Carotti Giovanni & Biondi Iris","IT4030004_PNATE_Gr_L1","Lago Bargetana","12:30","13:00","sole","sole","> 2","limpido","","","","","","44,255969","10,4041669","nessuno","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","","","",""},
			{"0002IB16","","PNATE","IT4030003","19/08/2016","Carotti Giovanni & Biondi Iris","IT4030003_PNATE_Gr_L2","Lago Pranda ","14:00","15:00","sole","sole","> 2","scarsa","","","","","","44,303949","10,241427","traps","0","0","0","0","0","0","","","","","","lago non idoneo alla specie per assenza di vegetazione acquatica.","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","","","","","","","","","","","","","",""},
			{"0003IB16","","PNATE","IT4030003","19/08/2016","Carotti Giovanni & Biondi Iris","IT4030003_PNATE_Gr_L3","Lago Pranda ","15:15","16:15","sole","sole","> 2","scarsa","","","","","","44,305649","10,240761","traps","0","0","0","0","0","0","","","","","","","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","","","","","","","","","","","","","",""},
			{"0004IB16","","PNATE","IT4030002 Ventasso","29/08/2016","Carotti Giovanni & Biondi Iris","IT4030002_PNATE_Gr_L4","Lago Calamone","12:00","13:00","sole","sole","> 2","scarsa","","","","","","44,381844","10,281172","net","0","0","0","0","0","0","","","","","","","N,0","N,0","N,0","","","","","","","","","","","","","","","","",""},
			{"0005IB16","","PNATE","IT4030002 Ventasso","29/08/2016","Carotti Giovanni & Biondi Iris","IT4030002_PNATE_Gr_L5","Lago Calamone","12:30","13:00","sole","sole","> 2","scarsa","","","","","","44,382714","10,279911","traps","0","0","0","0","0","0","","","","","","","T, 0","T, 0","T, 0","T, 0","","","","","","","","","","","","","","","",""},
			{"0006IB16","","PNATE","IT4020020","06/09/2016","Carotti Giovanni & Biondi Iris","IT4020020_PNATE_Gr_L6","Lago Squincio","12:00","13:00","sole","sole","> 2","scarsa","15,6","20","5,88","31,8","","44,382714","10,279911","traps","0","0","0","0","0","0","","","","","","","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","","","","",""},
			{"0007IB16","","PNATE","IT4020020","08/09/2016","Carotti Giovanni & Biondi Iris","IT4020020_PNATE_Gr_L7","Lago Verdarolo","12:00","13:00","sole","sole","> 2","scarsa","15,8","20","8,3","29,5","","44,358609","10,123316","traps","0","0","0","0","0","0","","","","","","non  stato possibile retinare per la presenza di fango profondo, dalla battigia subito profondo. Trappole 15.","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","","","","",""},
			{"0008IB16","","PNATE","IT4020020","08/09/2016","Carotti Giovanni & Biondi Iris","IT4020020_PNATE_Gr_L8","Lago Verdarolo","15:00","16:00","sole","sole","> 2","scarsa","","","","","","44,359444","10,1233333","net","0","0","0","0","0","0","","","","","","","N,0","N,0","N,0","N,0","N,0","N,0","N,0","","","","","","","","","","","","",""},
			{"0009IB16","","PNATE","IT4020020","09/09/2016","Carotti Giovanni & Biondi Iris","IT4020020_PNATE_Gr_L9","Trefiumi","10:00","14:00","sole","sole","1","limpido","19,1","20","8,03","153,7","","44,3808885","10,1120325","net","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","","","",""},
			{"00010IB16","","PNATE","IT4020020","13/09/2016","Carotti Giovanni & Biondi Iris","IT4020020_PNATE_Gr_L10","Lago Pradaccio","10:00","11:30","sole","sole","> 2","limpido","","","","","","44,3993371","10,019219","net","0","0","0","0","0","0","","","",""," Notonecta sp, Agabus sp. Dytiscus marginalis, Triturus alpestris","","N,0","N,0","N,0","","","","","","","","","","","","","","","","",""},
			{"00011IB16","","PNATE","IT4020020","13/09/2016","Carotti Giovanni & Biondi Iris","IT4020020_PNATE_Gr_L11","Lago Scuro","11:00","14:00","sole","sole","> 2","limpido","","","","","","44,357563","10,127806","nessuno","0","0","0","0","0","0","","","","","","Lago idoneo per reintroduzione. Solo retinatura perch laccesso al lago  possibile solo in un punto, difficoltoso perch si affonda ","","","","","","","","","","","","","","","","","","","",""},
			{"00012IB16","","PNATE","IT4020020","14/09/2016","Carotti Giovanni & Biondi Iris","IT4020020_PNATE_Gr_L12","Lagoni ","16:00","17:00","sole","sole","> 2","limpido","","","","","","44,3876897","10,0497762","traps","0","0","0","0","0","0","","","","","","lago non idoneo alla specie per assenza di vegetazione acquatica","T, 0","T, 0","T, 0","T, 0","T, 0","T, 0","","","","","","","","","","","","","",""},
			{"00013IB16","","PNATE","IT4030001","29/09/2016","Carotti Giovanni & Biondi Iris","IT4030001_PNATE_GrL13","Lago di Monte Acuto","11:00","14:00","sole","sole","> 2","limpido","","","","","","44,338178","10,168928","nessuno","0","0","0","0","0","0","","","","","","pesca regolamentata","","","","","","","","","","","","","","","","","","","",""},
			{"00014IB16","","PNATE","IT4030003","11/10/2016","Carotti Giovanni & Biondi Iris","IT4030003_PNATE_Gr_L14","Cerreto Laghi- sud del lago Scuro ","11:00","16:00","sole","sole","> 1","limpido","","","","","","44,302317","10,244126","net","5","0","0","0","0","0","","","","","","lago non idoneo alla specie per assenza di vegetazione acquatica ","N,0","N,0","N,0","N,0","N,0","","","","","","","","","","","","","","",""},
			{"00015IB17","","PNATE","IT4030003","17/05/2017","Carotti Giovanni & Biondi Iris","IT4030003_PNATE_Gr_L15","Lago Padule","11:00","13:00","sole","sole","2","limpida","15","22","7","200","","44,29997","10,21683","net e bottle-traps","3","0","0","0","0","0","","","","","Dytiscus marginalis","","N & T, 0","N & T, 0","N & T, 0","","","","","","","","","","","","","","","","",""},
			{"00016IB17","","PNATE","IT4030003","24/08/2017","Carotti Giovanni & Biondi Iris","IT4030003_PNATE_Gr_L16","Lago Padule","11:00","13:00","sole","sole","2","media (fino a 30 cm)","21","20","7,17","212","","44,29875","10,21758","net","8","0","0","0","0","0","","","","","","la retinatura  stata fatta lungo l'intero perimetro del bacino.","N,0","N,0","N,0","N,0","N,0","N,0","N,0","N,0","","","","","","","","","","","",""},
			{"00017IB17","","PNATE","IT4030001","29/08/2017","Carotti Giovanni & Biondi Iris","IT4030001_PNATE_Gr_L17","Lago Gonella","11:00","13:00","sole","sole","2","elevata","26","20","5,65","61","","44,3431313","10,1737485","net","4","0","0","0","0","0","","","","","","la retinatura  stata fatta lungo l'intero perimetro del bacino.","N,0","N,0","N,0","","","","","","","","","","","","","","","","",""},
			{"00018IB17","","PNATE","IT4020020","30/08/2017","Carotti Giovanni & Biondi Iris","IT4020020_PNATE_Gr_L18","Capanne Badignana","11:00","13:00","sole","sole","2","media","20","23","6,9","105,7","","44,38615","10,03019","net e bottle-traps","4","0","0","0","0","0","","","","","Dytiscus marginalis ","la retinatura  stata fatta intorno alla pozza","N &T, 0","N &T, 0","N &T, 0","T,0","","","","","","","","","","","","","","","",""},
			{"00019IB17","","PNATE","IT4020020","11/09/2017","Carotti Giovanni & Biondi Iris","IT4020020_PNATE_Gr_L19","Capanna Biancani","11:00","13:00","nebbia","nebbia e pioggia debole","2","media","11","15","6,42","58,8","","44,35472","10,09777","net e bottle-traps","10","0","0","0","0","0","","","","","Triturus alpestris. Agabus sp.","la retinatura  stata fatta intorno alle pozze. Sono rimaste 3 pozze, lago prosciugato per siccit.","N &T, 0","N &T, 0","N &T, 0","N &T, 0","N &T, 0","N &T, 0","N &T, 0","N &T, 0","N &T, 0","N &T, 0","","","","","","","","","",""},
			{"00020IB17","","PNATE","IT4030001","21/09/2017","Carotti Giovanni & Biondi Iris","IT4030001_PNATE_Gr_L20","Lago Mesc","11:27","14:39","sole","sole","2","media","14","25","5,5","66,2","","44,349906","10,19632","net e bottle-traps","4","0","0","0","0","0","","","","","Dytiscus marginalis; Triturus alpestris","","N &T, 0","N &T, 0","N &T, 0","T, 0","","","","","","","","","","","","","","","",""},
			{"0001MN16-GrS","","PNFC","IT5180018","22/07/2016","Norbiato M., Fabbri R.","IT5180018_PNFC_Gr_L1","LagMetaleto","8.45","9.30","sole","sole","1,2","elevata","10","13","7.91","300","","43,80743","11,8196","bottle-traps, net","0","0","0","0","0","0","8m tra una trap e l'altra, 4-5 m tra un Net e l'altro","","","varie","3 tritoni crestati; Heteroptera acquatici, no coleotteri","","N-0 es.","T-0","N-0","T-0","N-0","T-0","N-0","T-0","N-0","T-0","","","","","","","","","",""},
			{"0002RF16-GrS","","PNFC","IT5180018","24/07/2016","Fabbri R., Monterastelli E.","IT5180018_PNFC_Gr_L2","Lago Traversari","7.50","8.25","nuvoloso","nuvoloso","1,5","scarsa (fino 30 cm)","18","16","8.02","148","","43,78975","11,81582","bottle-traps","0","0","0","0","0","0","8m tra una trap e l'altra","","","varie","2 tritoni crestati(T 1); 3 crestati, 1 alpestre (T 2); 4 crestati (T 3); 8 crestati (T 4); 5 crestati(T 5)","","T-0","T-0","T-0","T-0","T-0","","","","","","","","","","","","","","",""},
			{"0002RF16-GrS","","PNFC","IT5180018","23/07/2016","Fabbri R., Monterastelli E.","IT5180018_PNFC_Gr_L2","Lago Traversari","11.00","13.00","sereno","sereno","1,5","scarsa (fino 30 cm)","20","24","8.07","150","","43,78975","11,81582","net","0","0","0","0","0","0","10m tra un Net e l'altro","","","varie","18 Acillus sulcatus(Net 1,4,5,6); 1 Agabus didymus(Net 2); Agabus palustris(Net 4); Haliplus sp.(Net 7)","","N-0 es.","N-0","N-0","N-0","N-0","N-0","N-0","N-0","","","","","","","","","","","",""},
			{"0003RF16-GrS","","PNFC","IT4080002","16/07/2016","Fabbri R., Laurens E.","IT4080002_PNFC_Gr_L3","Lago di Ponte","17.30","18.30","sereno","sereno","2","scarsa","23.5","26","8.15","420","","44,02934","11,69781","net","0","0","0","0","0","0","20m tra un Net e l'altro","","","varie","varie specie Odonati","","N-0 es.","N-0","N-0","N-0","N-0","N-0","","","","","","","","","","","","","",""},
			{"0001ST17-GrS","","PNFC","IT4080002","09/06/2017","Sterna","IT4080002_PNFC_Gr_L3","Lago di Ponte","17.00","18.40","sereno","sereno","2","scarsa","24","24.5","8.30","480","","44,02934","11,69781","net","0","0","0","0","0","0","20m tra un Net e l'altro","","","varie","solo alcuni Eterotteri e avanotti di probabili Carassi","","N-0 es.","N-0","N-0","N-0","N-0","N-0","","","","","","","","","","","","","",""},
			{"0002ST17-GrS","","PNFC","IT4080002","07/07/2017","Sterna","IT4080002_PNFC_Gr_L3","Lago di Ponte","17.00","18.15","sereno","sereno","","scarsa (fino 15 cm)","25","27.5-30.0","8.40","490","","44,02934","11,69781","net","0","0","0","0","0","0","20m tra un Net e l'altro","","","varie","Anodonta anatina 1 es.","","N-0 es.","N-0","N-0","N-0","N-0","N-0","","","","","","","","","","","","","",""},
			{"0003ST17-GrS","","PNFC","IT5180018","25/08/2017","Sterna, Sindaco R.","IT5180018_PNFC_Gr_L2","Lago Traversari","17.40","18.50","sereno","sereno","0,8","scarsa (fino 30 cm)","21.2","24.7","7.94","195","","43,78975","11,81582","net","0","0","0","0","0","0","10m tra un Net e l'altro","","","varie","Acilius sulcatus 1 es.","","N-0 es.","T-0","T-0","T-0","N-0","","","","","","","","","","","","","","",""},
			{"0004ST17-GrS","","PNFC","IT5180018","26/08/2017","Sterna, Burlin M., Ruocco M.","IT5180018_PNFC_Gr_L4","LagAsqua","10.30","11.30","sereno","sereno","max 1,00-media 0,30","elevata (>40 cm)","18.3","22.5","7.80","560","","43,79168","11,79569","net","0","0","0","0","0","0","5-7 m tra un Net e l'altro","","","varie","Hydroporus palustris 3 es., Rana dalmatina 1 es., Triturus vulgaris 1 es., Triturus cristatus 2 es.","","N-0 es.","T-0","T-0","T-0","N-0","","","","","","","","","","","","","","",""},
			{"0005ST17-GrS","","PNFC","IT5180018","25/08/2017","Sterna, Sindaco R.","IT5180018_PNFC_Gr_L1","LagMetaleto","16.30","17.30","sereno","sereno","media 0,50 ","elevata (>50 cm)","21.5","25.7","8.29","320","","43,80743","11,8196","net","0","0","0","0","0","0","5 m tra un Net e l'altro","","","varie","Austropotamobius italicus 5 es., Triturus cristatus 2 es.","","N-0 es.","T-0","T-0","T-0","N-0","","","","","","","","","","","","","","",""},
			};
			
			return ss;
			
	}
	
	public static String[] TRACCIATO_MH_GRAPHODERUS = {
			"scheda",
			"###",
			"ente",
			"sito",
			"data",
			"rilevatore",
			"transetto",
			"lunghezzaTransetto",
			"oraInizio",
			"oraFine",
			"provincia",
			"comune",
			"localita",
			"meta;nome_bacino;Nome bacino idrico",
			"meta;quota;Quota",
			"meta;x1;Coordinate N (WGS84, gradi) inizio transetto",
			"meta;y1;Coordinate E (WGS84, gradi) inizio transetto",
			"meta;x2;Coordinate N (WGS84, gradi) fine transetto",
			"meta;y2;Coordinate E (WGS84, gradi) fine transetto",
			"meta;ambiente;Ambiente",
			"meta;substrato;Substrato",
			"meta;dimensioni_bacino;Dimensioni bacino (Lu x La; m x m)",
			"meta;idon_transetto;Idoneit area transetto per specie",
			"meta;idon_transetto2;Idoneit area transetto per specie solo dopo interventi",
			"meta;interventi_previsti2;Interventi previsti",
			"meta;acqua_costante;Presenza acqua costante",
			"meta;alimentato_da2;Bacino alimentato da",
			"meta;profondita_max;Profondit max (m)",			
			"meta;limpidezza;Limpidezza",
			"meta;temp_acqua;Temperatura acqua (C)",
			"meta;temp_aria;Temperatura aria all'ombra (C)",
			"meta;ph;pH",
			"meta;conducibilita;Conducibilit (microS)",
			"meta;durezza;Durezza",
			"meta;lunghezza_margini2;Larghezza margini naturali attorno bacino nel transetto (m)",
			"meta;vegetazione_margini;Margini con vegetazione?",
			"meta;minacce;Minacce",
			"meta;erbe_elofite;% copertura erbe elofite emerse a foglia larga (es. Alisma, Mentha, Veronica, ...)",
			"meta;note_erbe_elofite;Nota erbe elofite",
			"meta;galleggianti;% copertura piante galleggianti a foglia larga (es.  Nymphaea, Nuphar, ...)",
			"meta;note_galleggianti;Nota piante galleggianti",
			"meta;piante_sommerse2;% copertura piante sommerse (es. Ranunculus, Ceratophyllum, Myriophyllum, ...)",
			"meta;note_piante_sommerse2;Nota piante sommerse",
			"meta;alghe;% copertura alghe (es. alghe filamentose, ...)",
			"meta;note_alghe;Nota alghe",
			"meta;arbor2;% copertura vegetazione arborea e arbustiva sulla sponda",
			"meta;note_arbor2;Nota vegetazione arborea",
			"meta;ombreggiamento2;% copertura ombreggiamento su acqua",
			"meta;note_ombreggiamento2;Nota ombreggiamento",
			"meta;erbac2;% copertura vegetazione erbacea sulla sponda",
			"meta;note_erbac2;Nota vegetazione erbacea",
			"meta;erbac_margine;Margine oltre sponda con vegetazione erbacea",
			"meta;acquatiche_altro;Altro (specificare; es. manufatti artificiali, variazioni nel transetto, ...)",
			"note",	
	};
	
	public static String[] TRACCIATO_MH_COENAGRION = {
			"scheda",
			"###",
			"ente",
			"sito",
			"data",
			"rilevatore",
			"transetto",
			"meta;id_corso_acqua;ID Corso d'acqua",
			"lunghezzaTransetto",
			"oraInizio",
			"oraFine",
			"provincia",
			"comune",
			"localita",
			"meta;nome_corso_acqua;Nome corso d'acqua",
			"meta;quota;Quota",
			"meta;x1;Coordinate N (WGS84, gradi) inizio transetto",
			"meta;y1;Coordinate E (WGS84, gradi) inizio transetto",
			//"meta;x2;Coordinate N (WGS84, gradi) fine transetto",
			//"meta;y2;Coordinate E (WGS84, gradi) fine transetto",
			"meta;ambiente;Ambiente",
			"meta;substrato;Substrato",
			"meta;larghezza_corso;Larghezza corso (cm)",
			"meta;larghezza_variazioni;Variazioni larghezza nel transetto",
			"meta;acqua_costante;Presenza acqua costante",
			"meta;velocita_acqua;Velocit acqua",
			"meta;alimentato_da;Corso d'acqua alimentato da",
			"meta;profondita;Profondit media (cm)",
			"meta;limpidezza;Limpidezza",
			"meta;temp_inizio;Temperatura acqua (C) inizio transetto",
			"meta;temp_fine;Temperatura acqua (C) fine transetto",
			"meta;temp_aria;Temperatura aria all'ombra (C)",
			"meta;ph;pH",
			"meta;conducibilita;Conducibilit (microS)",
			"meta;idon_transetto;Idoneit area transetto per specie",
			"meta;idon_transetto2;Idoneit area transetto per specie solo dopo interventi",
			"meta;interventi_previsti2;Interventi previsti",
			"meta;lunghezza_margini;Larghezza margini dx e sx del corso d'acqua (m)",
			"meta;vegetazione_margini;Margini con vegetazione?",
			"meta;minacce;Minacce",
			"meta;erbe_elofite;% copertura erbe elofite emerse a foglia larga (es. Alisma, Mentha, Veronica, ...)",
			"meta;note_erbe_elofite;Nota erbe elofite",
			"meta;altre_elofite;% copertura altre elofite emerse (es. Phragmites, Carex, Equisetum, Typha, Juncus, ...)",
			"meta;note_altre_elofite;Nota altre elofite",
			"meta;piante_sommerse;% copertura piante sommerse - idrofite (es. Ranunculus, Callitriche, ...)",
			"meta;note_piante_sommerse;Nota piante sommerse",
			"meta;alghe;% copertura alghe (es. alghe filamentose, ...)",
			"meta;note_alghe;Nota alghe",
			"meta;arbor;% copertura vegetazione arborea e arbustiva sulla sponda dx e sx",
			"meta;note_arbor;Nota vegetazione arborea",
			"meta;ombreggiamento;% copertura ombreggiatura su acqua",
			"meta;note_ombreggiamento;Nota ombreggiamento",
			"meta;erbac;% copertura vegetazione erbacea sulla sponda dx e sx",
			"meta;note_erbac;Nota vegetazione erbacea",
			"meta;erbac_dx;Margine dx, oltre sponda, con vegetazione erbacea",
			"meta;note_erbac_dx;Nota margine dx",
			"meta;erbac_sx;Margine sx, oltre sponda, con vegetazione erbacea",
			"meta;note_erbac_sx;Nota margine sx",
			"note",	
	};
	
	public static String[] TRACCIATO_MH_OSMODERMA = {
			"scheda",
			"###",
			"ente",
			"sito",
			"data",
			"rilevatore",
			"meta;id_albero_habitat;ID Albero Habitat",
			"transetto",
			"lunghezzaTransetto",
			"oraInizio",
			"oraFine",
			"provincia",
			"comune",
			"localita",
			"meta;quota;Quota",
			"x",
			"y",
			"meta;ambiente;Ambiente",
			"meta;substrato;Substrato",
			"meta;dimensioni_idonee;Dimensioni ed area idonea alla specie",
			"meta;specie_arborea;Specie arborea",
			"meta;cavita;Cavit presente",
			"meta;stato_salute_albero;Stato salute albero",
			"meta;funghi;Funghi presenti",
			"meta;tipo_gestione_albero;Tipo gestione albero",
			"meta;minacce;Minacce",
			"meta;temp_esterna;Temp. esterna all'ombra (C)",
			"meta;temp_interna;Temp. interna cavit (C)",
			"meta;ur_cavita;UR entro cavit (C)",
			"meta;eta_albero;Et albero",
			"meta;circonferenza;Circonferenza (cm) a 130cm da terra",
			"meta;altezza;Altezza (m)",
			"meta;altezza_cavita;Altezza cavit da terra (m)",
			"meta;dimensioni_entrata;Dimensioni entrata cavit (cm x cm)",
			"meta;inclinazione_entrata;Inclinazione entrata cavit (gradi)",
			"meta;esposizione;Esposizione entrata cavit (N,S,ecc.)",
			"meta;ispezionabile;Cavit ispezionabile",
			"meta;rosura;Cavit con rosura e/o acqua",
			"meta;profondita_cavita;Profondit cavit (cm)",
			"meta;quantita_rosura;Stima quantit rosura in cavit (litri)",
			"meta;presenza_resti;Presenza resti, larve, pellet, ecc.",
			"tipologia",
			"meta;annotazioni_cavita;Annotazioni su cavit",
			"meta;aduggiamento;Aduggiamento (%) e lato",
			"meta;piano_chioma;Piano chioma albero (dominante/sottoposto)",
			"meta;idoneita_ospitare;Idoneit cavit ad ospitare specie",
			"meta;idoneita_creare;Idoneit albero per creare o approfondire cavit",
			"meta;interventi_previsti;Interventi previsti su albero",
			"meta;interventi_vicini;Interventi previsti su alberi vicini",
			"meta;erba;% Copertura erbacea (entro 5m)",
			"meta;specie_erba;Specie erbacee (entro 5m)",
			"meta;arbusti;% Copertura arbustiva (entro 5m)",
			"meta;specie_arbusti;Specie arbustive (entro 5m)",
			"meta;arborea;% Copertura arborea (entro 5m)",
			"meta;specie_arboree;Specie arboree (entro 5m)",
			"meta;distanza_alberi;Distanza da altri alberi simili in dimensioni",
			"meta;specie_vicine;Specie alberi vicini",
			"meta;idoneita_cavi;Idoneit altri alberi a divenire cavi",
			"meta;distanza_cavi;Distanza da altri alberi cavi (e loro ID)",
			"meta;specie_cavi;Specie altre cave",
			"note",
			//"###",
			"meta;conta_alberi_os;Conta alberi monitoraggio Os",
			"meta;conta_interventi_os;Conta alberi interventi Os"
			
			
			
			
			
	};
	
	public static String[] TRACCIATO_MH_ROSALIA = {
			"scheda",
			"###",
			"ente",
			"sito",
			"data",
			"rilevatore",
			"meta;id_albero_habitat;ID Albero Habitat",
			"transetto",
			"lunghezzaTransetto",
			"oraInizio",
			"oraFine",
			"provincia",
			"comune",
			"localita",
			"meta;quota;Quota",
			"x",
			"y",
			"meta;ambiente;Ambiente",
			"meta;dimensioni_bosco;Dimensioni bosco, foresta, filare, parco, ecc. ed area idonea alla specie",
			"meta;substrato;Substrato",
			"meta;esposizione;Esposizione entrata cavit (N,S,ecc.)",
			"meta;inclinazione_entrata;Inclinazione entrata cavit (gradi)",
			
			
			"meta;specie_arborea;Specie arborea",
			"meta;minacce;Minacce",
			"meta;tipo_gestione_albero;Tipo gestione albero",
			"meta;altezza;Altezza (m)",
			"meta;eta_albero;Et albero",
			"meta;circonferenza;Circonferenza (cm) a 130cm da terra",
			"meta;sfarfallamento;Presenza sul tronco di fori di sfarfallamento, gallerie larvali, ecc. di Rosalia",
			"meta;altre_specie;Presenza altre specie",
			"meta;stato_salute_albero;Stato salute albero",
			"meta;stadio_albero;Stadio albero (1-9) e classe di decadimento (1-5)",
			"meta;legno_morto;Quantificazione parti di legno morto (%)",
			
			"meta;funghi;Funghi presenti",
			"meta;fori_picchi;Presenza di fori di picchi",
			"meta;pos_albero_morto;Se albero habitat morto indicare posizione",
			"meta;aduggiamento;Aduggiamento (%) e lato",
			"meta;piano_chioma;Piano chioma albero (dominante/sottoposto)",
			"meta;idoneita_ospitare2;Idoneit albero ad ospitare specie",
			"meta;idoneita_ospitare3;Idoneit albero vivo ad ospitare specie in seguito ad interventi",
			"meta;interventi_previsti;Interventi previsti su albero",
			"meta;cop_5_20;% Copertura vegetazione misurata entro 5 o 20 m",
			"meta;erba;% Copertura erbacea (entro 5m)",
			"meta;specie_erba;Specie erbacee (entro 5m)",
			"meta;arbusti;% Copertura arbustiva (entro 5m)",
			"meta;specie_arbusti;Specie arbustive (entro 5m)",
			"meta;arborea;% Copertura arborea (entro 5m)",
			"meta;specie_arboree;Specie arboree (entro 5m)",
			"meta;distanza_alberi2;Distanza da altro albero habitat o da gruppo di alberi (m)",
			"meta;specie_vicine;Specie alberi vicini",
			"meta;circonferenza2;Circonferenza (cm) a 130cm da terra",
			"meta;idoneita_altri;Idoneit altri alberi a ospitare specie",
			"meta;faggio;Presenza di cataste di tronchi di faggio",
			
			
			"note",
			"meta;conta_alberi_ros;Conta alberi monitoraggio Ros",
			"meta;conta_interventi_ros;Conta alberi interventi Ros"
			
			
			
			
			
	};
		
	
	public static void importaCoenagrion(String[][] s) {
		
		em = Accessor.getEremitaManager();
		Specie sp = em.getById(Specie.class,new Long(3938));
		int i = 0;
		
		for (String[] ss : s) {
			
			System.out.println("RECORD "+(i++));
			
			MonitoraggioSpecie ms = new MonitoraggioSpecie();
			if (ss[0]!=null && !"".equals(ss[0])) {
				List<MonitoraggioSpecie> ms2 = em.getSql(MonitoraggioSpecie.class, "select * from eremita_monitoraggio_specie where id_scheda='"+ss[0]+"' and transetto='"+ss[6]+"'");
				if (ms2!=null && ms2.size()>0) ms = ms2.get(0);
			}
			
			if (ms.getId()==null) {
					
				
				ms.setIdScheda(ss[0]);
				ms.setSpecie(sp);
				ms.setEnte(ss[2]);
				ms.setSito(getSito(ss[3]));
				ms.setDataCreazione(new Date());
				String dt = ss[4];
				String oraI = ss[9];
				oraI = oraI.replaceAll("\\.", ":");
				String oraF = ss[10];
				oraF = oraF.replaceAll("\\.", ":");
				try {
					Date dI = (oraI.equals("")?sdf.parse(dt):sdf2.parse(dt+" "+oraI));
					Date dF = (oraF.equals("")?sdf.parse(dt):sdf2.parse(dt+" "+oraF));
					ms.setTimestampInizioRilievo(dI);
					ms.setTimestampFineRilievo(dF);
				} catch (Exception e) {
					try {
						Date dI = (sdf.parse(dt));
						Date dF = (sdf.parse(dt));
						ms.setTimestampInizioRilievo(dI);
						ms.setTimestampFineRilievo(dF);
					} catch (Exception e1) {e1.printStackTrace();}
				}
				ms.setRilevatore(ss[5]);
				ms.setTransetto(ss[6]);
				if (!ss[7].equals("")) {
					ms.setLunghezzaTransetto(estraiNumero(ss[7]));
				}
				ms.setLocalita(ss[8]);
				ms.setMeteoInizio(condizioni(ss[11]));
				ms.setMeteoFine(condizioni(ss[12]));
				ms.setTemperaturaAria(estraiNumero(ss[13]));
				ms.setUmiditaRelativa(estraiNumero(ss[14]));
				ms.setVento(ss[15]);
				ms.setProfonditaMinAcqua(estraiNumero(ss[16]));
				ms.setLimpidezza(getLimpidezza(ss[17]));
				ms.setTemperaturaAcquaInizioTransetto(estraiNumero(ss[18]));
				ms.setTemperaturaAcquaFineTransetto(estraiNumero(ss[19]));
				ms.setpH(estraiNumero(ss[20]));
				ms.setConducibilita(estraiNumero(ss[21]));
				ms.setMinacce(ss[22]);
				ms.setCoordinataX(estraiNumero(ss[23]));
				ms.setCoordinataY(estraiNumero(ss[24]));
				
				ms.setTipologiaMonitoraggio(getTipo(ss[25]));
				ms.setNote(ss[35]);
				ms = em.updateAndCommit(ms);
			}
			
			Segnalazione seg = new Segnalazione();
			seg.setDataCreazione(new Date());
			seg.setMonitoraggioSpecie(ms);
			seg.setStadioSviluppo(em.getById(StadioSviluppo.class, "AM"));
			seg.setEsemplariM(estraiNumero(ss[26]));
			seg.setEsemplariF(estraiNumero(ss[27]));
			seg.setCoordinataX(estraiNumero(ss[23]));
			seg.setCoordinataY(estraiNumero(ss[24]));
			seg.setIdMarcatura(ss[31]);
			seg.setIdRicattura(ss[32]);
			seg.setFoto(ss[33]);
			seg.setNote((ss[30].equals("")?"":ss[30]+"; ")+
					(ss[42].equals("")?"":"Esemplari: "+ss[42]+";"+ss[43]+";"+ss[44]+";"+ss[45]));
			seg = em.updateAndCommit(seg);
			
			/*if (estraiNumero(ss[28]).intValue()>0) {
				seg = new Segnalazione();
				seg.setDataCreazione(new Date());
				seg.setMonitoraggioSpecie(ms);
				seg.setEsemplariMF(estraiNumero(ss[28]));
				seg.setStadioSviluppo(em.getById(StadioSviluppo.class, "RE"));
				seg = em.updateAndCommit(seg);
			}*/
			
			if (!"".equals(ss[34])) {
				SegnalazioneAltreSpecie sas = new SegnalazioneAltreSpecie();
				sas.setDataCreazione(new Date());
				sas.setMonitoraggioSpecie(ms);
				sas.setNote(ss[34]);
				sas = em.updateAndCommit(sas);
			}
			
			
		}
	}
	
	
public static void importaCoenagrionNew(String[][] s) {
		
		em = Accessor.getEremitaManager();
		Specie sp = em.getById(Specie.class,new Long(3938));
		int i = 0;
		
		for (String[] ss : s) {
			
			System.out.println("RECORD "+(i++));
			
			MonitoraggioSpecie ms = new MonitoraggioSpecie();
			if (ss[0]!=null && !"".equals(ss[0])) {
				List<MonitoraggioSpecie> ms2 = em.getSql(MonitoraggioSpecie.class, "select * from eremita_monitoraggio_specie where id_scheda='"+ss[0]+"' and transetto='"+ss[6]+"'");
				if (ms2!=null && ms2.size()>0) ms = ms2.get(0);
			}
			
			if (ms.getId()==null) {
					
				
				ms.setIdScheda(ss[0]);
				ms.setSpecie(sp);
				ms.setEnte(ss[2]);
				ms.setSito(getSito(ss[3]));
				ms.setDataCreazione(new Date());
				String dt = ss[4];
				String oraI = ss[11];
				oraI = oraI.replaceAll("\\.", ":");
				String oraF = ss[12];
				oraF = oraF.replaceAll("\\.", ":");
				try {
					Date dI = (oraI.equals("")?sdf.parse(dt):sdf2.parse(dt+" "+oraI));
					Date dF = (oraF.equals("")?sdf.parse(dt):sdf2.parse(dt+" "+oraF));
					ms.setTimestampInizioRilievo(dI);
					ms.setTimestampFineRilievo(dF);
				} catch (Exception e) {
					try {
						Date dI = (sdf.parse(dt));
						Date dF = (sdf.parse(dt));
						ms.setTimestampInizioRilievo(dI);
						ms.setTimestampFineRilievo(dF);
					} catch (Exception e1) {e1.printStackTrace();}
				}
				ms.setRilevatore(ss[5]);
				ms.setTransetto(ss[6]);
				if (!ss[9].equals("")) {
					ms.setLunghezzaTransetto(estraiNumero(ss[9]));
				}
				ms.setLocalita(ss[10]);
				ms.setMeteoInizio(condizioni(ss[13]));
				ms.setMeteoFine(condizioni(ss[14]));
				ms.setTemperaturaAria(estraiNumero(ss[15]));
				ms.setUmiditaRelativa(estraiNumero(ss[16]));
				ms.setVento(ss[17]);
				ms.setProfonditaMinAcqua(estraiNumero(ss[18]));
				ms.setLimpidezza(getLimpidezza(ss[19]));
				ms.setTemperaturaAcquaInizioTransetto(estraiNumero(ss[20]));
				ms.setTemperaturaAcquaFineTransetto(estraiNumero(ss[21]));
				ms.setpH(estraiNumero(ss[22]));
				ms.setConducibilita(estraiNumero(ss[23]));
				ms.setMinacce(ss[24]);
				ms.setCoordinataX(estraiNumero(ss[7]));
				ms.setCoordinataY(estraiNumero(ss[8]));
				
				ms.setTipologiaMonitoraggio(getTipo(ss[27]));
				ms.setNote(ss[37]);
				ms = em.updateAndCommit(ms);
			}
			
			Segnalazione seg = new Segnalazione();
			seg.setDataCreazione(new Date());
			seg.setMonitoraggioSpecie(ms);
			seg.setStadioSviluppo(em.getById(StadioSviluppo.class, "AM"));
			seg.setEsemplariM(estraiNumero(ss[28]));
			seg.setEsemplariF(estraiNumero(ss[29]));
			seg.setCoordinataX(estraiNumero(ss[7]));
			seg.setCoordinataY(estraiNumero(ss[8]));
			seg.setIdMarcatura(ss[33]);
			seg.setIdRicattura(ss[34]);
			seg.setFoto(ss[35]);
			seg.setNote((ss[32].equals("")?"":ss[32]+"; ")+
					(ss[42].equals("")?"":"Esemplari: "+ss[44]+";"+ss[45]+";"+ss[46]+";"+ss[47]));
			seg = em.updateAndCommit(seg);
			
			/*if (estraiNumero(ss[28]).intValue()>0) {
				seg = new Segnalazione();
				seg.setDataCreazione(new Date());
				seg.setMonitoraggioSpecie(ms);
				seg.setEsemplariMF(estraiNumero(ss[28]));
				seg.setStadioSviluppo(em.getById(StadioSviluppo.class, "RE"));
				seg = em.updateAndCommit(seg);
			}*/
			
			if (!"".equals(ss[36])) {
				SegnalazioneAltreSpecie sas = new SegnalazioneAltreSpecie();
				sas.setDataCreazione(new Date());
				sas.setMonitoraggioSpecie(ms);
				sas.setNote(ss[36]);
				sas = em.updateAndCommit(sas);
			}
			
			
		}
	}	
	
public static void importaGraphoderus(String[][] s) {
		
		em = Accessor.getEremitaManager();
		Specie sp = em.getById(Specie.class,new Long(1971));
		int i = 0;
		
		for (String[] ss : s) {
			
			System.out.println("RECORD "+(i++));
			
			MonitoraggioSpecie ms = new MonitoraggioSpecie();
			
			if (ss[0]!=null && !"".equals(ss[0])) {
				List<MonitoraggioSpecie> ms2 = em.getSql(MonitoraggioSpecie.class, "select * from eremita_monitoraggio_specie where id_scheda='"+ss[0]+"' and transetto='"+ss[6]+"'");
				if (ms2!=null && ms2.size()>0) ms = ms2.get(0);
			}
			
			if (ms.getId()==null) {
			
				ms.setIdScheda(ss[0]);
				ms.setSpecie(sp);
				ms.setEnte(ss[2]);
				ms.setSito(getSito(ss[3]));
				ms.setDataCreazione(new Date());
				String dt = ss[4];
				String oraI = ss[8];
				oraI = oraI.replaceAll("\\.", ":");
				String oraF = ss[9];
				oraF = oraF.replaceAll("\\.", ":");
				try {
					Date dI = (oraI.equals("")?sdf.parse(dt):sdf2.parse(dt+" "+oraI));
					Date dF = (oraF.equals("")?sdf.parse(dt):sdf2.parse(dt+" "+oraF));
					ms.setTimestampInizioRilievo(dI);
					ms.setTimestampFineRilievo(dF);
				} catch (Exception e) {
					try {
						Date dI = (sdf.parse(dt));
						Date dF = (sdf.parse(dt));
						ms.setTimestampInizioRilievo(dI);
						ms.setTimestampFineRilievo(dF);
					} catch (Exception e1) {e1.printStackTrace();}
				}
				ms.setRilevatore(ss[5]);
				ms.setTransetto(ss[6]);
	
				ms.setLocalita(ss[7]);
				ms.setMeteoInizio(condizioni(ss[10]));
				ms.setMeteoFine(condizioni(ss[11]));
				ms.setProfonditaMaxAcqua(estraiNumero(ss[12]));
				ms.setLimpidezza(getLimpidezza(ss[13]));
				ms.setTemperaturaAcquaInizioTransetto(estraiNumero(ss[14]));
				ms.setTemperaturaAria(estraiNumero(ss[15]));
				ms.setpH(estraiNumero(ss[16]));
				ms.setConducibilita(estraiNumero(ss[17]));
				ms.setDurezza(estraiNumero(ss[18]));
				
				ms.setTipologiaMonitoraggio(getTipo(ss[21]));
				ms.setNumeroPunti(estraiNumero(ss[22]));
				ms.setCoordinataX(estraiNumero(ss[19]));
				ms.setCoordinataY(estraiNumero(ss[20]));
				
				ms.setNote(ss[33]);
				ms = em.updateAndCommit(ms);
			}
			
			Segnalazione seg = new Segnalazione();
			seg.setDataCreazione(new Date());
			seg.setMonitoraggioSpecie(ms);
			seg.setStadioSviluppo(em.getById(StadioSviluppo.class, "AM"));
			seg.setEsemplariM(estraiNumero(ss[23]));
			seg.setEsemplariF(estraiNumero(ss[24]));
			seg.setCoordinataX(estraiNumero(ss[19]));
			seg.setCoordinataY(estraiNumero(ss[20]));
			seg.setIdMarcatura(ss[29]);
			seg.setIdRicattura(ss[30]);
			seg.setFoto(ss[31]);
			seg.setNote(ss[28]);
			seg = em.updateAndCommit(seg);
			
			
			if (!"".equals(ss[32])) {
				SegnalazioneAltreSpecie sas = new SegnalazioneAltreSpecie();
				sas.setDataCreazione(new Date());
				sas.setMonitoraggioSpecie(ms);
				sas.setNote(ss[32]);
				sas = em.updateAndCommit(sas);
			}
			
			
		}
	}

public static void importaGraphoderusNew(String[][] s) {
	
	em = Accessor.getEremitaManager();
	Specie sp = em.getById(Specie.class,new Long(1971));
	int i = 0;
	
	for (String[] ss : s) {
		
		System.out.println("RECORD "+(i++));
		
		MonitoraggioSpecie ms = new MonitoraggioSpecie();
		
		if (ss[0]!=null && !"".equals(ss[0])) {
			List<MonitoraggioSpecie> ms2 = em.getSql(MonitoraggioSpecie.class, "select * from eremita_monitoraggio_specie where id_scheda='"+ss[0]+"' and transetto='"+ss[6]+"'");
			if (ms2!=null && ms2.size()>0) ms = ms2.get(0);
		}
		
		if (ms.getId()==null) {
		
			ms.setIdScheda(ss[0]);
			ms.setSpecie(sp);
			ms.setEnte(ss[2]);
			ms.setSito(getSito(ss[3]));
			ms.setDataCreazione(new Date());
			String dt = ss[4];
			String oraI = ss[9];
			oraI = oraI.replaceAll("\\.", ":");
			String oraF = ss[10];
			oraF = oraF.replaceAll("\\.", ":");
			try {
				Date dI = (oraI.equals("")?sdf.parse(dt):sdf2.parse(dt+" "+oraI));
				Date dF = (oraF.equals("")?sdf.parse(dt):sdf2.parse(dt+" "+oraF));
				ms.setTimestampInizioRilievo(dI);
				ms.setTimestampFineRilievo(dF);
			} catch (Exception e) {
				try {
					Date dI = (sdf.parse(dt));
					Date dF = (sdf.parse(dt));
					ms.setTimestampInizioRilievo(dI);
					ms.setTimestampFineRilievo(dF);
				} catch (Exception e1) {e1.printStackTrace();}
			}
			ms.setRilevatore(ss[5]);
			ms.setTransetto(ss[6]);

			ms.setLocalita(ss[8]);
			ms.setMeteoInizio(condizioni(ss[11]));
			ms.setMeteoFine(condizioni(ss[12]));
			ms.setProfonditaMaxAcqua(estraiNumero(ss[13]));
			ms.setLimpidezza(getLimpidezza(ss[14]));
			ms.setTemperaturaAcquaInizioTransetto(estraiNumero(ss[15]));
			ms.setTemperaturaAria(estraiNumero(ss[16]));
			ms.setpH(estraiNumero(ss[17]));
			ms.setConducibilita(estraiNumero(ss[18]));
			ms.setDurezza(estraiNumero(ss[19]));
			
			ms.setTipologiaMonitoraggio(getTipo(ss[7]));
			ms.setNumeroPunti(estraiNumero(ss[22]));
			ms.setCoordinataX(estraiNumero(ss[20]));
			ms.setCoordinataY(estraiNumero(ss[21]));
			
			ms.setNote(ss[34]);
			ms = em.updateAndCommit(ms);
		}
		
		Segnalazione seg = new Segnalazione();
		seg.setDataCreazione(new Date());
		seg.setMonitoraggioSpecie(ms);
		seg.setStadioSviluppo(em.getById(StadioSviluppo.class, "AM"));
		seg.setEsemplariM(estraiNumero(ss[23]));
		seg.setEsemplariF(estraiNumero(ss[24]));
		seg.setCoordinataX(estraiNumero(ss[20]));
		seg.setCoordinataY(estraiNumero(ss[21]));
		seg.setIdMarcatura(ss[30]);
		seg.setIdRicattura(ss[31]);
		seg.setFoto(ss[32]);
		seg.setNote(ss[29]);
		seg = em.updateAndCommit(seg);
		
		
		if (!"".equals(ss[33])) {
			SegnalazioneAltreSpecie sas = new SegnalazioneAltreSpecie();
			sas.setDataCreazione(new Date());
			sas.setMonitoraggioSpecie(ms);
			sas.setNote(ss[33]);
			sas = em.updateAndCommit(sas);
		}
		
		
	}
}


public static void importaOsmoderma(String[][] s) {
	
	em = Accessor.getEremitaManager();
	Specie sp = em.getById(Specie.class,new Long(1874));
	int i = 0;
	
	for (String[] ss : s) {
		
		System.out.println("RECORD "+(i++));
		
		MonitoraggioSpecie ms = new MonitoraggioSpecie();
		
		
		if (ss[0]!=null && !"".equals(ss[0])) {
			List<MonitoraggioSpecie> ms2 = em.getSql(MonitoraggioSpecie.class, "select * from eremita_monitoraggio_specie where id_scheda='"+ss[0]+"' and transetto='"+ss[6]+"'");
			if (ms2!=null && ms2.size()>0) ms = ms2.get(0);
		}
		
		if (ms.getId()==null) {
			
			ms.setIdScheda(ss[0]);
			ms.setSpecie(sp);
			ms.setEnte(ss[2]);
			ms.setSito(getSito(ss[3]));
			ms.setDataCreazione(new Date());
			String dt = ss[4];
			String oraI = ss[9];
			oraI = oraI.replaceAll("\\.", ":");
			String oraF = ss[10];
			oraF = oraF.replaceAll("\\.", ":");
			try {
				Date dI = (oraI.equals("")?sdf.parse(dt):sdf2.parse(dt+" "+oraI));
				Date dF = (oraF.equals("")?sdf.parse(dt):sdf2.parse(dt+" "+oraF));
				ms.setTimestampInizioRilievo(dI);
				ms.setTimestampFineRilievo(dF);
			} catch (Exception e) {
				try {
					Date dI = (sdf.parse(dt));
					Date dF = (sdf.parse(dt));
					ms.setTimestampInizioRilievo(dI);
					ms.setTimestampFineRilievo(dF);
				} catch (Exception e1) {e1.printStackTrace();}
			}
			ms.setRilevatore(ss[5]);
			ms.setTransetto(ss[6]);
			ms.setLunghezzaTransetto(estraiNumero(ss[7]));
	
			ms.setLocalita(ss[8]);
			ms.setMeteoInizio(condizioni(ss[11]));
			ms.setMeteoFine(condizioni(ss[12]));
			ms.setTemperaturaAria(estraiNumero(ss[13]));
			ms.setUmiditaRelativa(estraiNumero(ss[14]));
			ms.setVento(ss[15]);
			ms.setCoordinataX(estraiNumero(ss[16]));
			ms.setCoordinataY(estraiNumero(ss[17]));
			
			ms.setTipologiaMonitoraggio(getTipo(ss[18]));
	
			
			
			ms.setNote(ss[29]);
			ms.setNumeroPunti(estraiNumero(ss[30]));
			ms = em.updateAndCommit(ms);
		}
		
		Segnalazione seg = new Segnalazione();
		seg.setDataCreazione(new Date());
		seg.setMonitoraggioSpecie(ms);
		seg.setIdHabitat(ss[19]);
		seg.setStadioSviluppo(em.getById(StadioSviluppo.class, "AM"));
		seg.setEsemplariM(estraiNumero(ss[20]));
		seg.setEsemplariF(estraiNumero(ss[21]));
		seg.setIdMarcatura(ss[25]);
		seg.setIdRicattura(ss[26]);
		seg.setCoordinataX(estraiNumero(ss[16]));
		seg.setCoordinataY(estraiNumero(ss[17]));
		seg.setFoto(ss[27]);
		seg.setNote(ss[24]);
	
		seg = em.updateAndCommit(seg);
		
		if (estraiNumero(ss[22]).intValue()>0) {
			seg = new Segnalazione();
			seg.setDataCreazione(new Date());
			seg.setMonitoraggioSpecie(ms);
			seg.setIdHabitat(ss[19]);
			seg.setStadioSviluppo(em.getById(StadioSviluppo.class, "RE"));
			seg.setEsemplariMF(estraiNumero(ss[22]));
			seg.setCoordinataX(estraiNumero(ss[16]));
			seg.setCoordinataY(estraiNumero(ss[17]));
			seg = em.updateAndCommit(seg);
		}
		
		if (estraiNumero(ss[31]).intValue()>0) {
			seg = new Segnalazione();
			seg.setDataCreazione(new Date());
			seg.setMonitoraggioSpecie(ms);
			seg.setIdHabitat(ss[19]);
			seg.setStadioSviluppo(em.getById(StadioSviluppo.class, "AI"));
			seg.setEsemplariMF(estraiNumero(ss[31]));
			seg.setCoordinataX(estraiNumero(ss[16]));
			seg.setCoordinataY(estraiNumero(ss[17]));
			seg = em.updateAndCommit(seg);
		}
		
		if (estraiNumero(ss[32]).intValue()>0) {
			seg = new Segnalazione();
			seg.setDataCreazione(new Date());
			seg.setMonitoraggioSpecie(ms);
			seg.setIdHabitat(ss[19]);
			seg.setStadioSviluppo(em.getById(StadioSviluppo.class, "L"));
			seg.setEsemplariMF(estraiNumero(ss[32]));
			seg.setCoordinataX(estraiNumero(ss[16]));
			seg.setCoordinataY(estraiNumero(ss[17]));
			seg = em.updateAndCommit(seg);
		}
		
		
		if (!"".equals(ss[28])) {
			SegnalazioneAltreSpecie sas = new SegnalazioneAltreSpecie();
			sas.setDataCreazione(new Date());
			sas.setMonitoraggioSpecie(ms);
			sas.setNote(ss[28]);
			sas = em.updateAndCommit(sas);
		}
		
		
	}
}





public static void importaRosalia(String[][] s) {
	
	em = Accessor.getEremitaManager();
	Specie sp = em.getById(Specie.class,new Long(1834));
	int i = 0;
	
	for (String[] ss : s) {
		
		System.out.println("RECORD "+(i++));
		
		
		MonitoraggioSpecie ms = new MonitoraggioSpecie();
		if (ss[0]!=null && !"".equals(ss[0])) {
			List<MonitoraggioSpecie> ms2 = em.getSql(MonitoraggioSpecie.class, "select * from eremita_monitoraggio_specie where id_scheda='"+ss[0]+"' and transetto='"+ss[6]+"'");
			if (ms2!=null && ms2.size()>0) ms = ms2.get(0);
		}
		
		if (ms.getId()==null) {
			ms.setIdScheda(ss[0]);
			ms.setSpecie(sp);
			ms.setEnte(ss[2]);
			ms.setSito(getSito(ss[3]));
			
			ms.setDataCreazione(new Date());
			String dt = ss[4];
			String oraI = ss[9];
			oraI = oraI.replaceAll("\\.", ":");
			String oraF = ss[10];
			oraF = oraF.replaceAll("\\.", ":");
			try {
				Date dI = (oraI.equals("")?sdf.parse(dt):sdf2.parse(dt+" "+oraI));
				Date dF = (oraF.equals("")?sdf.parse(dt):sdf2.parse(dt+" "+oraF));
				ms.setTimestampInizioRilievo(dI);
				ms.setTimestampFineRilievo(dF);
			} catch (Exception e) {
				try {
					Date dI = (sdf.parse(dt));
					Date dF = (sdf.parse(dt));
					ms.setTimestampInizioRilievo(dI);
					ms.setTimestampFineRilievo(dF);
				} catch (Exception e1) {e1.printStackTrace();}
			}
			ms.setRilevatore(ss[5]);
			ms.setTransetto(ss[6]);
	
			ms.setLocalita(ss[8]);
			ms.setMeteoInizio(condizioni(ss[11]));
			ms.setMeteoFine(condizioni(ss[12]));
			ms.setTemperaturaAria(estraiNumero(ss[13]));
			ms.setUmiditaRelativa(estraiNumero(ss[14]));
			ms.setVento(ss[15]);
			ms.setCoordinataX(estraiNumero(ss[16]));
			ms.setCoordinataY(estraiNumero(ss[17]));
			ms.setTipologiaMonitoraggio(getTipo(ss[18]));
	
			
			
			ms.setNote(ss[29]);
			ms.setNumeroPunti(estraiNumero(ss[30]));
			ms = em.updateAndCommit(ms);
		}
		
		Segnalazione seg = new Segnalazione();
		seg.setDataCreazione(new Date());
		seg.setMonitoraggioSpecie(ms);
		seg.setIdHabitat(ss[19]);
		seg.setStadioSviluppo(em.getById(StadioSviluppo.class, "AM"));
		seg.setEsemplariM(estraiNumero(ss[20]));
		seg.setEsemplariF(estraiNumero(ss[21]));
		seg.setIdMarcatura(ss[25]);
		seg.setIdRicattura(ss[26]);
		seg.setCoordinataX(estraiNumero(ss[16]));
		seg.setCoordinataY(estraiNumero(ss[17]));
		seg.setFoto(ss[27]);
		seg.setNote(ss[24]);
		seg = em.updateAndCommit(seg);
		
		if (estraiNumero(ss[22]).intValue()>0) {
			seg = new Segnalazione();
			seg.setDataCreazione(new Date());
			seg.setMonitoraggioSpecie(ms);
			seg.setIdHabitat(ss[19]);
			seg.setStadioSviluppo(em.getById(StadioSviluppo.class, "RE"));
			seg.setEsemplariMF(estraiNumero(ss[22]));
			seg.setCoordinataX(estraiNumero(ss[16]));
			seg.setCoordinataY(estraiNumero(ss[17]));
			seg = em.updateAndCommit(seg);
		}
		
		if (estraiNumero(ss[31]).intValue()>0) {
			seg = new Segnalazione();
			seg.setDataCreazione(new Date());
			seg.setMonitoraggioSpecie(ms);
			seg.setIdHabitat(ss[19]);
			seg.setStadioSviluppo(em.getById(StadioSviluppo.class, "AI"));
			seg.setEsemplariMF(estraiNumero(ss[31]));
			seg.setCoordinataX(estraiNumero(ss[16]));
			seg.setCoordinataY(estraiNumero(ss[17]));
			seg = em.updateAndCommit(seg);
		}
		
		if (estraiNumero(ss[32]).intValue()>0) {
			seg = new Segnalazione();
			seg.setDataCreazione(new Date());
			seg.setMonitoraggioSpecie(ms);
			seg.setIdHabitat(ss[19]);
			seg.setStadioSviluppo(em.getById(StadioSviluppo.class, "L"));
			seg.setEsemplariMF(estraiNumero(ss[32]));
			seg.setCoordinataX(estraiNumero(ss[16]));
			seg.setCoordinataY(estraiNumero(ss[17]));
			seg = em.updateAndCommit(seg);
		}
		
		
		if (!"".equals(ss[28])) {
			SegnalazioneAltreSpecie sas = new SegnalazioneAltreSpecie();
			sas.setDataCreazione(new Date());
			sas.setMonitoraggioSpecie(ms);
			sas.setNote(ss[28]);
			sas = em.updateAndCommit(sas);
		}
		
		
	}
}
	
	
	public static CondizioniMeteo condizioni(String s) {
		if (s==null || "".equals(s)) return null;
		if (s.contains("sole") || s.contains("sereno"))
			return em.getById(CondizioniMeteo.class, "sole");
		if (s.contains("10%") || s.contains("20%") || s.contains("30%") || s.contains("40%"))
			return em.getById(CondizioniMeteo.class, "poco_nuvoloso");
		if (s.contains("50%") || s.contains("60%") || s.contains("70%") || s.contains("40%") || s.contains("nuvoloso"))
			return em.getById(CondizioniMeteo.class, "nuvoloso");
		if (s.contains("80%") || s.contains("90%") || s.contains("100%"))
			return em.getById(CondizioniMeteo.class, "molto_nuvoloso");
		if (s.contains("pioggia"))
			return em.getById(CondizioniMeteo.class, "pioggia");
		return null;
	}
	
	public static BigDecimal estraiNumero(String s) {
		try {
		if (s==null || "".equals(s)) return new BigDecimal(0.0);
		if (!"".equals(s)) s = s.split("-")[0];
		if (!"".equals(s)) s = s.split(" ")[0];
		if (!"".equals(s)) s = s.split("/")[0];
		if (!"".equals(s)) s = s.split("")[0];
		s = s.replace(",", ".");
		
			return new BigDecimal(s);
		} catch (Exception e) {
			System.out.println("ERRORE: "+s);
			return new BigDecimal(0);
		}
	}
	
	public static Limpidezza getLimpidezza(String s) {
		if (s==null || "".equals(s)) return null;
		if (s.contains("elevata")) return em.getById(Limpidezza.class, "limpidezza_elevata");
		if (s.contains("media")) return em.getById(Limpidezza.class, "limpidezza_media");
		if (s.contains("scarsa")) return em.getById(Limpidezza.class, "limpidezza_scarsa");
		return null;
	}
	
	public static TipologiaMonitoraggio getTipo(String s) {
		if (s==null || "".equals(s)) return null;
		s = s.split(",")[0];
		TipologiaMonitoraggio tm = em.getById(TipologiaMonitoraggio.class, s);
		if (tm==null) {
			tm = new TipologiaMonitoraggio();
			tm.setId(s);
			tm.setEtichetta(s);
			tm = em.updateAndCommit(tm);
		}
		return tm;
	}
	
	
	public static SitoNatura2000 getSito(String s) {
		
		if (s==null || !s.startsWith("IT")) return null;
		SitoNatura2000 sito = em.getById(SitoNatura2000.class, s.split(" ")[0]);
		if (sito!=null) return sito;
		
		sito = new SitoNatura2000();
		int i = s.indexOf(' ');
		String id = (i==-1? s : s.substring(0, i));
		String name = (i==-1? "" : s.substring(i+1).toUpperCase());
		sito.setId(id);
		sito.setNome(name);
		em.updateAndCommit(sito);
		return sito;
	}
	
	public static void importaMonitoraggiHabitat(String[][] s, long specie, String[] colonne) {
		
		em = Accessor.getEremitaManager();
		Specie sp = em.getById(Specie.class,new Long(specie));
		int index = 0;
		for (String[] riga : s) {
			System.out.println("INDEX "+(index++));
			MonitoraggioHabitat mh = new MonitoraggioHabitat();
			mh.setSpecie(sp);
			String data = "";
			
			for (int k=0; k<colonne.length; k++) {
				String dato = riga[k];
				String significato = colonne[k];
				
				
				if (significato.equals("scheda")) {
					mh.setIdScheda(dato);
				}
				
				if (significato.equals("rilevatore")) {
					mh.setRilevatore(dato);
				}
				
				if (significato.equals("sito")) {
					mh.setSito(getSito(dato));
				}
				
				if (significato.equals("x")) {
					mh.setCoordinataX(estraiNumero(dato));
				}
				
				if (significato.equals("y")) {
					mh.setCoordinataY(estraiNumero(dato));
				}
				
				if (significato.equals("provincia")) {
					mh.setProvincia(dato);
				}
				
				if (significato.equals("comune")) {
					mh.setComune(dato);
				}
				
				if (significato.equals("localita")) {
					mh.setLocalita(dato);
				}
				
				if (significato.equals("data")) {
					data = dato;
				}
				
				if (significato.equals("oraInizio")) {
					if (dato!=null && !"".equals(dato)) {
						dato = dato.replaceAll("\\.", ":");
						try {
							mh.setTimestampInizioRilievo(new Timestamp(sdf2.parse(data+" "+dato).getTime()));
						} catch (Exception e) {}
					} else {
						try {
							mh.setTimestampInizioRilievo(new Timestamp(sdf.parse(data).getTime()));
						} catch (Exception e) {}
					}
				}
				
				if (significato.equals("oraFine")) {
					if (dato!=null && !"".equals(dato)) {
						dato = dato.replaceAll("\\.", ":");
						try {
							mh.setTimestampFineRilievo(new Timestamp(sdf2.parse(data+" "+dato).getTime()));
						} catch (Exception e) {}
					} else {
						try {
							mh.setTimestampFineRilievo(new Timestamp(sdf.parse(data).getTime()));
						} catch (Exception e) {}
					}
				}
				
				if (significato.equals("transetto")) {
					mh.setTransetto(dato);
				}
				
				if (significato.equals("lunghezzaTransetto")) {
					mh.setLunghezzaTransetto(estraiNumero(dato));
				}
				
				if (significato.equals("tipologia")) {
					mh.setTipologiaMonitoraggio(getTipo(dato));
				}
				
				if (significato.equals("note")) {
					mh.setNote(dato!=null&&dato.length()>255?dato.substring(0, 255):dato);
				}
				
				if (significato.equals("ente")) {
					mh.setEnte(dato);
				}
				
			}
			
			mh = em.updateAndCommit(mh); //fine dati base
			
			for (int k=0; k<colonne.length; k++) {
				String dato = riga[k];
				String significato = colonne[k];
				
				if (significato.startsWith("meta")) {
					String sig[] = significato.split(";");
					String nomeMetadato = sig[1];
					String descrizione = sig[2];
					Metadato m = getMetadato(nomeMetadato,descrizione);
					MetadatoHabitat met = new MetadatoHabitat();
					met.setMetadato(m);
					met.setMonitoraggioHabitat(mh);
					met.setValore(dato);
					em.updateAndCommit(met);
				}
			}
		}
	}
	
	public static Metadato getMetadato(String name, String descr) {
		
		Metadato m = em.getById(Metadato.class,name);
		if (m!=null) return m;
		
		m = new Metadato();
		m.setId(name);
		m.setDescrizione(descr);
		m = em.updateAndCommit(m);
		
		return m;
	}
	
	public static String[][] importaCSV(String path) throws Exception {
		
		Reader r = new FileReader(path);
		
		CSVReader reader = new CSVReader(r, ';', '"');
		List<String[]> l = reader.readAll();
		String[][] ll = new String[l.size()-1][];
		for (int k=1; k<l.size(); k++) {
			ll[k-1] = l.get(k);
		}
		
		return ll;
	}

}
